#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
#
fc="`which ${FC:?}`"
fflags="-I${MODINSTDIR:?} ${SYSFFLAGS}"
libs="-L${LIBINSTDIR:?} -l${LIBNAME:?}"

ldflags=${SYSLDFLAGS}
ldlibs=${SYSLDLIBS:?}
out=${1:-dclf90}

if [ ${F90MODTYPE:?} = intel.d ]; then
	ldlibs=`echo $ldlibs | sed s/-lm//`
fi

cat > $out <<EOF
#!/bin/sh

fc="$fc"
fflags="$fflags"
libs="$libs"
ldflags="$ldflags"
ldlibs="$ldlibs"

EOF

if [ ${F90MODTYPE:?} = intel.d ]; then

	cat >> $out <<EOF
# support for Intel Fortran
	if [ ! -f work.pcl ]; then
		echo work.pc > work.pcl
	fi
	for arg in \$fflags
	do
	    case "\$arg" in
	    -I*)
		dir=\`echo \$arg | sed s/-I//\`
		if [ ! -f \$dir/work.pc ]; then
			echo Notice: \$dir/work.pc not exist, and ignored.
			touch work.pcl
			break
		fi
		if ! grep -q "^\$dir/work.pc\\$" work.pcl
		then
			echo adding \$dir
			echo \$dir/work.pc >> work.pcl
		fi
		;;
	    esac
	done
EOF

fi

cat >> $out <<EOF

exec \$fc \$fflags "\$@" \$libs \$ldflags \$ldlibs
EOF
