! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTContLoad(Cont, var)
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    use gtgraph_generic, only: Load
    use gtdata_generic  ! ςg珑̂͂
    use dc_types, only: STRING
    use dc_error
    implicit none
    type(GT_CONTOURS), intent(out):: Cont
    type(GT_VARIABLE), intent(in):: var
    character(STRING):: varname
    character(*), parameter:: GTCT = 'gt_graph_contours_'
    ! N data ł邱Ƃ
    call get_attr(var, "gt_structure_link_data", varname)
    if (varname == "") then
        call StoreError(GT_EBADLINK, "GTContLoad(data variable)")
        return
    endif
    call Open(cont%var, varname)
    cont%contours = attr_true(var, GTCT//'draw_contours', default=.TRUE.)
    cont%shade = attr_true(var, GTCT//'draw_shade', default=.FALSE.)
    allocate(cont%h_axis, cont%v_axis)
    call get_attr(var, "gt_structure_link_haxis", varname)
    call Load(cont%h_axis, varname)
    call get_attr(var, "gt_structure_link_vaxis", varname)
    call Load(cont%v_axis, varname)
    ! IvV̏
    call get_attr(var, GTCT//'interval', cont%interval, default=0.0)
    call get_attr(var, GTCT//'thick_cycle', cont%icycle, default=0)
    call get_attr(var, GTCT//'levels', cont%levels)
    call get_attr(var, GTCT//'skiplevels', cont%skiplevels)
    call get_attr(var, GTCT//'tone_number', cont%tones) ! experimental
    call get_attr(var, GTCT//'base_level', cont%base, default=0.0) ! experimental
    call get_attr(var, "gt_graph_draw_map", cont%map, default="")
end subroutine

