! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
! NCbNr[A

! f[^𗭂ߍނ߂̘gƐ}ЂƂÂpӂB
! R}hCЂƂЂƂϐƂĊJāA
!    }`ϐȂ΂̂܂ (it) gɓA
!    f[^ϐȂΕW}s (it) }ɓA
!    ϐł͂ȂIvVw`Ȃ itAW}AWg̏
!    IvVƂė^邱Ƃ݂B
! R}hCȂ΃f[^ϐ "" JĐ}ɓ
! }ɉĂΘgɓ
! g\

program gtview
    use gtool
    use dcl, only: DclSetParm
    use dc_trace, only: setdebug
    implicit none
    character(STRING):: argument, optname, optvalue
    character(STRING):: var_stack = ""
    character(STRING):: figure_title = ""
    character(STRING):: slice_spec
    type(GT_OBJECT):: it
    type(GT_FIGURE):: fig
    type(GT_FRAME):: frame
    type(GT_DEVICE):: dev
    integer:: i
    logical:: it_built = .FALSE.
    logical:: save_mode = .FALSE.
    logical:: disp_mode = .TRUE.
    logical:: double_mode = .FALSE.
    logical:: err
continue
    call Open(frame)
    call Open(fig)
    call Open(it)
    arg_loop: do, i = 1, GtArgCount()
        call GtArgGet(i, argument)
        if (GtOptionForm(argument, optname, optvalue)) then
            if (optname == 'wsn') then
                gtdev_wsn_default = stoi(optvalue)
            else if (optname == '-debug' .or. optname == '-D') then
                call setdebug
            else if (optname == '-save') then
                save_mode = .TRUE.
            else if (optname == '-batch') then
                disp_mode = .FALSE.
                save_mode = .TRUE.
            else if (optname == '-vect' .or. optname == '-Ve') then
                double_mode = .TRUE.
            else if (optname == '-smooth' .or. optname == '-Gaw') then
                call SWLSTX('LALT', .TRUE.)
                call SWLSTX('LWAIT', .FALSE.)
            else if (optname == '-nowait' .or. optname == '-Gw') then
                call SWLSTX('LWAIT', .FALSE.)
            else if (optname == '-alternate' .or. optname == '-Ga') then
                call SWLSTX('LALT', .TRUE.)
            else if (optname == "title") then
                figure_title = optvalue
            else if (optname == "slice") then
                slice_spec = optvalue
            else
                call Option(it, trim(optname), &
                    & trim(optvalue), err=err)
                if (err) then
                    call Option(fig, trim(optname), trim(optvalue), err=err)
                    if (err) then
                        call put_line("option " // trim(argument) // " ignored")
                    endif
                endif
            endif
        else
            if (it_built) then
        !        if (type(it) == "") then
                    call Bind(fig, it)
        !        else
        !            call Bind(frame, it)
        !        endif
            endif
            if (double_mode) then
                if (var_stack == '') then
                    var_stack = argument
                else
                    call Load(it, var_stack, argument, slice=slice_spec)
                    double_mode = .false.
                    var_stack = ""
                        it_built = .TRUE.
                endif
            else
                call Load(it, argument, slice=slice_spec)
                it_built = .TRUE.
            endif
        endif
    enddo arg_loop
    if (.not. it_built) then
        argument = ""
        call Load(it, argument, slice="")
    endif
    call Bind(fig, it)
    if (figure_title /= "") fig%title = figure_title
    ! 悢 figure ̗p
    if (disp_mode) then
        call Open(dev)
        call Display(dev, fig)
    endif
    if (save_mode) call Save(fig)
    call Close(fig)
    if (disp_mode) call Close(dev)
end program

