! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTVarPutLine(var, err)
    use gtdata_types, only: GT_VARIABLE
    use dc_error
    use dc_string, only: toChar, put_line
    use gtdata_generic, only: Get, Inquire
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_VARIABLE), intent(inout):: var
    logical, intent(out), optional:: err
    real, allocatable:: rvalue(:)
    integer:: siz, stat, i
    logical:: myerr

    call beginsub('gtvarputline', '%d', i=(/var%mapid/))
    call Inquire(var, size=siz)
    call message('size = %d', i=(/siz/))
    stat = 0
    allocate(rvalue(siz), stat=stat)
    if (stat /= 0) then
        stat = GT_ENOMEM
        goto 950
    endif
    call Get(var, rvalue, size(rvalue), err=myerr)
    if (myerr) then
        stat = errorcode()
        goto 950
    endif
    do, i = 1, size(rvalue)
        call put_line(trim(toChar(rvalue(i))))
    end do
    deallocate(rvalue, stat=stat)
    if (stat /= 0) stat = GT_ENOMEM
    !
950 continue
    call StoreError(stat, "GTVarPutLine", err)
    call endsub('gtvarputline', '%d stat=%d', i=(/var%mapid, stat/))
end subroutine
