! sysdep.f90 - module providing interface for system dependent procedures
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved
!
!=begin
!= module sysdep
!It provides interface for system dependent procedures.
!In other words, there is interface declaration of a function and subroutines
!whose feature is regarded as system dependent.
!Implementation of these procedures are given in files with corresponding name
!(i.e. that begins with (({sysdep}))-).
!
!Note that a procedure with one name may have several implementations.
!The most typical and recommended installation uses 
!((<DCL|URL:http://www.gfd-dennou.org/arch/dcl/>)) internally.
!However, you can use other options when you have to use a misconfigured
!installation of DCL or when you care about more advanced issues like
!the exit code of process.
!
!The (({sysdep})) has no dependence to other modules.
!=end

module sysdep

    !=begin
    !== procedure interface
    !=end

    private
    public:: AbortProgram, SysdepArgGet, SysdepArgCount

    !=begin
    !--- AbortProgram(str) subroutine
    !    ((|str|)) is (({character(len = *)})).
    !    ((*AbortProgram*)) terminates program.
    !    It is a generic name of a subroutine.
    !    In fact, the subroutine was given another name ((<SysdepAbort>)),
    !    in order to make it easier to find the source code.
    !    Though many implementations are trying to set exit code
    !    other than zero, that should ((*not*)) be relied upon.
    !=end

    interface AbortProgram
        subroutine SysdepAbort(string)
            character(len = *):: string
        end subroutine
    end interface

    interface

        !=begin
        !--- SysdepArgCount() integer function
        !    gets the number of commandline arguments.
        !    Most typically, it is implemented by nonstandard built-in
        !    function (({IARGC()})) through a DCL subroutine ((<OSQARN>)).
        !=end

        integer function SysdepArgCount()
        end function

        !=begin
        !--- SysdepArgGet(index, value) integer function
        !    ((|index|)) is (({integer, intent(in)})).
        !    ((|value|)) is (({character(len = *)})).
        !    gets the ((|index|))th commandline argument.
        !    If ((|index|)) is more than the number of arguments,
        !    ((|value|)) will be filled with blank.
        !    Most typically, it is implemented by nonstandard built-in
        !    subroutine (({GETARG()})) through a DCL subroutine ((<OSGARG>)).
        !=end

        subroutine SysdepArgGet(index, value)
            integer, intent(in):: index
            character(len = *):: value
        end subroutine

    end interface

end module
