#!/bin/sh
#= Generate shell script "gt5frt".
#
# Authors::   Youhei SASAKI, Yasuhiro MORIKAWA, Eizi TOYODA
# Copyright:: Copyright (C) GFD Dennou Club, 2000-2017. All rights reserved.
# License::   See COPYRIGHT[link:../COPYRIGHT]
#
prefix=$PREFIX
version=$VERSION
out=`basename ${1:-gt5frt}`

cat > $out <<EOF
#!/bin/sh
#=begin
#== NAME
#((* $out *)) -- script for fortran usin gtool5
#
#Wrapper shell script for fortran compiler using gtool5
#
#== SYNTAX
#
# % $out [fortran_compiler_option] fortran_program.f90
#
#== DESCRIPTION
#
#((* $out *)) is simple shell script.
#This script set environment variables for using gtool5 library.
#
#== OPTION
#
#:fortran_compiler_option
#  commonly used fortran compiler option, see your fortran compiler manual
#
#== BUGS
#
#If you find a bug, please report it at SPMODEL Development Group
#<dcstaff_(at)_gfd-dennou.org>
#=end

EOF


cat >> $out <<EOF
prefix="$prefix"
exec_prefix=${prefix}
bindir=${prefix}/bin
gt5config=${prefix}/bin/gt5config
version="$version"

fc=\`\$gt5config --fc\`
mpifc=\`\$gt5config --mpifc\`
fcflags=\`\$gt5config --fcflags\`
ldflags=\`\$gt5config --ldflags\`
ldlibs=\`\$gt5config --ldlibs\`
version="$version"

EOF

if test x"$out" = x"mpigt5frt" ; then
cat >> $out <<EOF

echo \$mpifc \$fcflags "\$@" \$ldflags \$ldlibs
exec \$mpifc \$fcflags "\$@" \$ldflags \$ldlibs
EOF
else
cat >> $out <<EOF

echo \$fc \$fcflags "\$@" \$ldflags \$ldlibs
exec \$fc \$fcflags "\$@" \$ldflags \$ldlibs
EOF
fi
