# _DC_FORTRAN_MODULE_OUTPUT_FLAG
# ----------------------------------------------------------------------
# Copyright (c) 2025 Youhei SASAKI <uwabami@gfd-dennou.org>
#
# Copying and distribution of this file, with or without modification, are
# permitted in any medium without royalty provided the copyright notice
# and this notice are preserved. This file is offered as-is, without any
# warranty.
#
# DESCRIPTION:
# Check for Fortran compiler flag to specify module output directory
#
# MEMO:
# -J : gfortran
# -module : ifort, ifx, PGI
# -moddir= : Sun/Oracle
# -mdir : NAG
# -qmoddir= : IBM XL
# ??: HITACHI
#
# ----------------------------------------------------------------------
AC_DEFUN([DC_FORTRAN_MODOUT_FLAG],
[
  AC_CACHE_CHECK(
    [$FC module path output flag],
    [ac_cv_dcf90_modout_flag],
    [
      ac_cv_dcf90_modout_flag="NG"

      AC_LANG_PUSH(Fortran)

      rm -rf conftest_module_dir
      mkdir conftest_module_dir

      for flag in "-J" "-module " "-moddir=" "-mdir " "-qmoddir="; do
        save_FCFLAGS="$FCFLAGS"
        FCFLAGS="$FCFLAGS ${flag}conftest_module_dir"

        AC_COMPILE_IFELSE([AC_LANG_SOURCE([
          module conftest_module
          end module conftest_module
        ])], [
          if test -f conftest_module_dir/conftest_module$MODEXT || \
             test -f conftest_module_dir/CONFTEST_MODULE$MODEXT; then
            ac_cv_dcf90_modout_flag="$flag"
          fi
        ])
        FCFLAGS="$save_FCFLAGS"
        if test "x$ac_cv_dcf90_modout_flag" != x"NG"; then
          break
        fi
      done

      rm -rf conftest_module_dir
      AC_LANG_POP(Fortran)
    ]
  )

  if test "x$ac_cv_dcf90_modout_flag" = x"NG"; then
    AC_MSG_ERROR([unable to find $FC module output flag])
  else
    MODOUTFLAG="$ac_cv_dcf90_modout_flag"
  fi
  AC_SUBST([MODOUTFLAG])
])
