# Upgrade from gt4f90io                                   {#transition-gt4f90io}
@ja
## インストールについて

インストールについては *gt4f90io と同様です*.
詳細は [gtool5 インストールガイド](@ref INSTALL)を参照して下さい.

ただし, デフォルトのインストール先が
`/usr/local/gt4f90io` から `/usr/local/gtool5` に変更になります.

## 使用の際には

### Fortran プログラムの変更について

gt4f90io から gtool5 に移行するにあたり, 以下のように
一部のモジュールの名称が変更になりました. ただし,
gtool5 では旧名称のものも使用可能であるため,
*特に利用者側でプログラムを変更する必要はありません*.


gt4f90io でのモジュールの名称 | gtool5 でのモジュールの名称
------------------------------|----------------------------
`gt4f90io`                    | `gtool5`
`gt4_history`                 | `gtool_history`

### プログラムのコンパイルについて

gt4f90io ではプログラムのコンパイル, およびコンパイルオプションを
表示するためのするためのスクリプトとして
*gt4frt*,
*gt4config*
を提供していましたが, gtool5 ではこれらが
*gt5frt*,
*gt5config*
に変更になります.

また, ライブラリの名称が
*libgt4f90io.a*
から
*libgtool5.a*
に変更したため,ライブラリの名称を明示的に指定してコンパイルする場合には,
この点についても変更してください.

@endja
@en
## Installation

Installation is *same as gt4f90io.*
See [gtool5 Installation Guide](@ref INSTALL)
for details.

Note that a default install destination is changed
from `/usr/local/gt4f90io' to `/usr/local/gtool5'.

## Usage

### About your Fortran programs

Names of some of modules are changed as follows
along with transition from "gt4f90io" to "gtool5".
However, *you need not change your programs*
because old names are available in "gtool5".

Names of modules in gt4f90io  | Names of modules in gtool5
------------------------------|---------------------------
`gt4f90io`                    | `gtool5`
`gt4_history`                 | `gtool_history`


### Compilation of programs

*gt4frt*,
*gt4config* are provided
by "gt4f90io" for compilation of programs, and
display of options for compilation. These are changed to
*gt5frt*,
*gt5config*
in "gtool5".

A library name is changed from
*libgt4f90io.a*
to
*libgtool5.a*,
so if you specified a library name explicitly for complication, change the name.

@enden
