
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//         Reza Nekovei <reza@intcomm.net>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.
 
// (c) COPYRIGHT URI/MIT 1994-1996
// Please read the full copyright statement in the file COPYRIGHT.
//
// Authors:
//      reza            Reza Nekovei (reza@intcomm.net)

// DODS-netCDF surrogate library functions for data dimensions. See note
// about the symbol LOCAL in Dfile.c
// 
// ReZa 10/6/94

#include "config_nc.h"

#include <cstring>

static char rcsid[] not_used ={"$Id: Ddim.cc 18782 2008-05-23 16:39:07Z jimg $"};

#include "Dnetcdf.h"

int
nc_def_dim(int cdfid, const char *name, size_t size, int *dimidp)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_def_dim((*conns)[cdfid]->get_ncid(), name, size, dimidp);
      return rcode;
    }
#endif

    return NC_EPERM;
}

int
nc_inq_dimid(int cdfid, const char *name, int *dimid_ptr)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_inq_dimid((*conns)[cdfid]->get_ncid(), name, dimid_ptr);
      return rcode;
    }
#endif

    int dimid = -1;

    for (int i = 0; i < (*conns)[cdfid]->get_ndims(); i++)
	if ((*conns)[cdfid]->dim_name(i) == name) {
	  dimid = i;
	  break;
	}
  
    if(dimid == -1)
      return NC_EBADDIM;

    *dimid_ptr = dimid;
    return NC_NOERR;
}

int
nc_inq_dim(int cdfid, int dimid, char *name, size_t *sizep)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_inq_dim((*conns)[cdfid]->get_ncid(), dimid, name, sizep);
      return rcode;
    }
#endif

    if(( dimid < 0) || (dimid > (*conns)[cdfid]->get_ndims())) 
      return NC_EBADDIM ;

    if (name != NULL) 
	(void) strcpy (name, (*conns)[cdfid]->dim_name(dimid).c_str());

    if(sizep != 0) 
	*sizep = (size_t) (*conns)[cdfid]->dim_size(dimid); 
    
    return NC_NOERR;
}


int 
nc_inq_dimname(int cdfid, int dimid, char *name)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_inq_dimname((*conns)[cdfid]->get_ncid(), dimid, name);
      return rcode;
    }
#endif

    if(( dimid < 0) || (dimid > (*conns)[cdfid]->get_ndims())) 
      return NC_EBADDIM ;

    if (name != NULL) 
	(void) strcpy (name, (*conns)[cdfid]->dim_name(dimid).c_str());

    return NC_NOERR;
}


int 
nc_inq_dimlen(int cdfid, int dimid, size_t *lenp)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_inq_dimlen((*conns)[cdfid]->get_ncid(), dimid, lenp);
      return rcode;
    }
#endif

    if(( dimid < 0) || (dimid > (*conns)[cdfid]->get_ndims())) 
      return NC_EBADDIM ;

    if(lenp != 0) 
	*lenp = (size_t) (*conns)[cdfid]->dim_size(dimid); 
    
    return NC_NOERR;
}


int
nc_rename_dim(int cdfid, int dimid, const char *newname)
{
    if (!conns || cdfid < 0 || cdfid > MAX_NC_OPEN 
	|| (*conns)[cdfid] == NULL) // does the file id exist?
	return NC_EBADID;

#ifdef LOCAL
    if((*conns)[cdfid]->is_local()) {
      rcode = lnc_rename_dim((*conns)[cdfid]->get_ncid(), dimid, newname);
      return rcode;
    }
#endif

    return NC_EPERM;
}

// $Log: Ddim.cc,v $
// Revision 1.9  2005/05/11 20:17:35  jimg
// Changes for the new build: libnc-dap is now in it's own CVS module and
// builds using autoconf 2.5.7 scripts.
//
// Revision 1.8  2004/07/28 18:10:05  jimg
// Fixed handling of global attributes. I used the new code in
// DDS::transfer_attributes().
//
// Revision 1.7  2004/07/26 19:10:44  jimg
// Moved netCDF CL <--> OPeNDAP server interface code to nc_util and
// NCConnect.
//
// Revision 1.6  2004/03/09 22:56:32  jimg
// Refactored so that Pix is no longer used. Some common code (in the
// glue routines) was also factored out to functions. The netCDF 2
// interface is now supplied by the lnetcdf/lv2i.c file (which is a mostly
// unaltered copy of the original v2i.c source file). See lnetcdf/README.
//
// Revision 1.5  2004/03/08 19:08:33  jimg
// This version of the code uses the Unidata netCDF 3.5.1 version of the
// netCDF 2 API emulation. This functions call our netCDF 3 API functions
// which may either interact with a DAP server r call the local netCDF 3
// functions.
//
// Revision 1.4  2003/12/08 18:06:37  edavis
// Merge release-3-4 into trunk
//
// Revision 1.3  2000/10/06 01:22:02  jimg
// Moved the CVS Log entries to the ends of files.
// Modified the read() methods to match the new definition in the dap library.
// Added exception handlers in various places to catch exceptions thrown
// by the dap library.
//
// Revision 1.2  1999/11/05 05:15:04  jimg
// Result of merge woth 3-1-0
//
// Revision 1.1.2.1  1999/10/15 19:50:55  jimg
// Changed return values and conditions for NC API entry points
//
// Revision 1.1  1999/07/28 00:22:41  jimg
// Added
//
// Revision 1.9  1999/05/07 23:45:30  jimg
// String --> string fixes
//
// Revision 1.8  1997/03/25 16:16:28  reza
// Fixed CVS duplicate log reports.
//
// Revision 1.7  1997/02/28 23:32:40  jimg
// Fixed bad assign to rcode in conditional. This was the (in)famous ferret
// bug.
//
// Revision 1.6  1996/09/17 00:26:07  jimg
// Merged changes from a side branch which contained various changes from
// Reza and Charles.
// Removed ncdump and netexec since ncdump is now in its own directory and
// netexec is no longer used.
//
// Revision 1.5  1995/07/10 05:07:40  reza
// added fortran jacket support.
//
// Revision 1.4.2.1  1996/04/02 19:25:04  jimg
// Changed the `conns' variable so that now it is a global *pointer*, not an
// object. Each call that might add to the conns object must first check to see
// that it has been created. This was done because of link-time problems with
// static global objects.
// Fixed up some comment stuff.
// Added assert() calls for conns.
//
// Revision 1.4  1995/07/09  21:33:32  jimg
// Added copyright notice.
//
// Revision 1.3  1994/12/08  19:01:29  reza
// Added support for local netCDF file access through the original netCDF code.
//
// Revision 1.2  1994/11/23  21:05:56  reza
// First working version.
//
// Revision 1.1  1994/11/03  04:35:46  reza
// Preliminary version of netCDF -> DODS library.
