#!/usr/bin/env ruby
require("gsl")
include GSL
include Blas

x = Vector[1, 2, 3]
y = Vector[4, 5, 6]

p x.blas_ddot(y)
p Blas.ddot(x, y)

xz = Vector::Complex.new([1, 0], [2, 0], [3, 0])
yz = Vector::Complex.new([4, 0], [5, 0], [6, 0])
p zdotu(xz, yz)

p x.nrm2
p Blas.dnrm2(x)
p xz.nrm2
p Blas.dznrm2(xz)

p x.asum
p Blas.dasum(x)
p xz.asum
p Blas.dzasum(xz)

x.swap(y)
p x
p y

Blas.dswap(x, y)
p x
p y

xz.swap(yz)
p xz
p yz

Blas.zswap(xz, yz)
p xz
p yz

p x.axpy(2, y)
p y
p Blas.daxpy(2, x, y)
p y

p x.axpy!(2, y)
p y
p Blas.daxpy!(2, x, y)
p y

y = Vector[4, 5, 6]

az = GSL::Complex.new(2, 0)
p xz.zaxpy(az, yz)
p yz
p Blas.zaxpy(az, xz, yz)
p yz

az = GSL::Complex[2, 0]
p xz.axpy!(az, yz)
p yz
p Blas.zaxpy!(az, xz, yz)
p yz

yz = Vector::Complex.new([4, 0], [5, 0], [6, 0])

p x.scal(2)
p x

p x.scal!(2)
p x

x = Vector[1, 2, 3]

p xz.zscal(az)
p xz.zdscal(2)

p y
p Blas.drot(x, y, 2, 3)
p drot(x, y, 2, 3)
