=begin
= test program for NumRu::Derivative
=end

require 'derivative.rb'
include NumRu::Derivative
include NMath

nx = 10
x1 = 2*PI*NArray.sfloat(nx).indgen!/(nx-1)
z1 = sin(x1)
c1 = cderiv(z1, x1, 0)
k1 = cos(x1)
print "\n1-dimentional data\n"
p ((c1 - k1).abs.max)

ny = 70; nz = 10; nx=144
x3 = 2*PI*(NArray.sfloat(nx).indgen!/(nx-1))      # [0, .., 2PI]
y3 =   PI*(NArray.sfloat(ny).indgen!/(ny-1)-0.5)  # [-PI/2,..,PI/2]
z3 =      (NArray.sfloat(nz).indgen!)             # [0, 1, .., 10]
d3 = (sin(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
dzx = cderiv(d3, x3, 0)
dzy = cderiv(d3, y3, 1)
dzz = cderiv(d3, z3, 2)
dzx2 =  (cos(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
dzy2 = -(sin(x3).newdim(-1).newdim(-1))*(sin(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
dzz2 =  (sin(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1))

print "\n3-dimentional data\n"
p ((dzx - dzx2).abs.max)
p ((dzy - dzy2).abs.max)
p ((dzz - dzz2).abs.max)
      
