
require "narray"
require "ispack"
require "numru/dcl"
include NumRu
include NMath # NArrayޤ뤴sin,expʤɤα黻Ǥ⥸塼롣


#mm = 85; jm = 128; im = 256
mm = 21; jm = 32; im = 64
lm = (mm+1)*(mm+1)

time = 0.0
dt = 1.0/80.0
omg = 1.0

st = STPACK.new(mm,jm,im)
y,x = st.ogrd()
y = y.newdim!(1) # 2ˤ


# 

  u0   = 270.0 * 86.4/40000.0 # m/s -> a Omega
  phi0 = 55.0  * PI/180.0     # deg -> rad
  b0   = 4.0   * PI/180.0     # deg -> rad

  u = NArray.float(jm,im)
  u[true,true] = u0*cos(y)*(1+tanh( (y-phi0)/b0 ))/2.0 # tanhå
  v = NArray.float(jm,im).fill!(0.0)

  pv0 = st.vrsa(u,v)            # u,vб٤Ѵ
  pv0 = ISPACK::ndtv2a(omg,pv0) # б٤б٤Ѵ


# ͤ

  pv = pv0 + 0.000001000000


def drawinit # եå

  DCL::sglset('lcorner',false)
  DCL::gllset('lmiss',true)
  DCL::gliset('msglev',2)

  DCL::sglset('lsoftf',false)
  DCL::sglset('lfull',true)
  DCL::sglset('lcntl',true)
  DCL::udlset('lmsg',false)

  DCL::sglset( 'lclip', true )
  DCL::sgiset( 'ifont', 2 )

  DCL::swistx( 'iwidth', 512 )
  DCL::swistx( 'iheight', 512 )

  DCL::swlset( 'lalt', TRUE )
  DCL::swlset( 'lwait', FALSE )

  DCL::gropn(1)

  DCL::sgrset( 'stlat1', 45.0 )
  DCL::sgrset( 'stlat2', 30.0 )
  DCL::umlset( 'lgridmn', FALSE )
  DCL::umiset( 'indexmj', 1 )
  DCL::umiset( 'itypemj', 3 )
  DCL::sgstxs( 0.035 )
  DCL::sgstxi( 3 )

end

def check(mm,time,pv) # ͥ륮󥹥ȥեå
  omg = 1.0
#  psi = NArray.float((mm+1)*(mm+1))
  psi = ISPACK::ndca2p(mm,omg,pv)
  ene = ISPACK::ndgeea(mm,psi)
  ens = ISPACK::ndgena(mm,psi)
  printf("%4.2f %12.10f %12.10f\n",time, ene, ens)
end

def derivative(pv,pv0,st) # dq/dt = -J(,q) -(q-q0) +ͦ(q-q0)

  rank = 1
  mm = st.mm
  nu = 1.0/(mm*(mm+1)-2.0)**rank
  alpha = 0.1

  omg = 1.0
  psi = ISPACK::ndca2p(mm,omg,pv)
  jacobian = st.ajba(psi,pv) * (-2*PI)
  relax = - alpha * (pv - pv0)
  viscous = nu * (st.clfa(pv-pv0)+2.0*(pv-pv0))**rank

  dpvdt = jacobian + relax + viscous

end

def integral(time,dt,pv,pv0,st) # 󥲥åʬ

  d1 = derivative(pv,pv0,st)
  w = pv + d1*dt/2.0
  d2 = derivative(w,pv0,st)
  w = pv + d2*dt/2.0
  d3 = derivative(w,pv0,st)
  w = pv + d3*dt
  d4 = derivative(w,pv0,st)

  pv = pv + (d1 + d2*2.0 + d3*2.0 + d4)/6.0*dt
  time  = time + dt

  return time,pv
end

def draw(s,st)

  DCL::sgfrm
  DCL::sgswnd( 0.0, 360.0, -90.0, 90.0 )
  DCL::sgssim( 0.5, 0.0,0.0 )
  DCL::sgsmpl( 0.0, 90.0, 0.0 )
  DCL::sgstxy( -180.0, 180.0, 30.0, 90.0 )
  DCL::sgstrn( 33 )
  DCL::sgstrf

  g = st.s2ga(s)
  DCL::umpgrd
  DCL::udsfmt('(i3)')                      # label format
  DCL::udiset('icycle',5)
  DCL::udgcla(1.0,5.0,0.2)

  g1 = NArray.sfloat(st.jm,(st.im+1))
  g1[true,0..-2] = g
  g1[true,-1] = g[true,0]
  DCL::udcntz(g1.transpose(1,0))
end

drawinit

check(mm,time,pv)
draw(pv,st)

for i in 1..10
  for j in 1..80
    time,pv = integral(time,dt,pv,pv0,st)
  end
  check(mm,time,pv)
  draw(pv,st)
end

DCL::grcls

