*************************************************************************
*   ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING          *
*   Copyright (C) 1998 Keiichi Ishioka                                  *
*                                                                       *
*   This library is free software; you can redistribute it and/or       *
*   modify it under the terms of the GNU Library General Public         *
*   License as published by the Free Software Foundation; either        *
*   version 2 of the License, or (at your option) any later version.    *
*                                                                       *
*   This library is distributed in the hope that it will be useful,     *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of      *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   *
*   Library General Public License for more details.                    *
*                                                                       *
*   You should have received a copy of the GNU Library General Public   *
*   License along with this library; if not, write to the Free          *
*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *
*************************************************************************
************************************************************************
*     CALCULATE THE POSITION OF A SPECTRUM COEFFICIENT OF P_N^M 98/01/06
*-----------------------------------------------------------------------
*     IF M.GE.0 --> REAL PART
*     IF M.LT.0 --> IMAGINARY PART
************************************************************************
      SUBROUTINE SMNM2L(MM,N,M,L)

      IF(M.GE.0) THEN
        L=M+1+(N+1)*MM
      ELSE
        L=1+(MM-N)*(MM+1)+N+M
      END IF

      END
************************************************************************
      SUBROUTINE SML2NM(MM,L,N,M)

      J=(L-1)/(MM+1)
      K=L-J*(MM+1)-1
      M=K-(MM-J)
      IF(M.GE.0) THEN
        N=J
      ELSE
        N=MM-J
      END IF

      END
