!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wa_deriv_mpi_module
!
!  spml/wa_deriv_module ⥸塼ϵ̾Ǥήαư
!  ĴȡѤڥȥˡ MPI 󲽤ˤä
!  ͷ׻뤿Υ⥸塼 wa_mpi_module β⥸塼Ǥ, 
!  ڥȥˡʬ׻Τ Fortran90 ؿ󶡤. 
!
!  ̾ 1 إǥ w_deriv_mpi_module ⥸塼¿إǥѤ
!  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
!  ФѴԤ.
!
!   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
!
!  2008/05/28  ݹ wa_deriv_module MPI 
!
module wa_deriv_mpi_module
  !
  ! wa_deriv_mpi_module
  !
  !  spml/wa_deriv_module ⥸塼ϵ̾Ǥήαư
  !  ĴȡѤڥȥˡ MPI 󲽤ˤä
  !  ͷ׻뤿Υ⥸塼 wa_mpi_module β⥸塼Ǥ, 
  !  ڥȥˡʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !  ̾ 1 إǥ w_deriv_mpi_module ⥸塼¿إǥѤ
  !  ĥΤǤ, ƱʣĤΥڥȥǡ, ʻǡ
  !  ФѴԤ.
  !
  !   ISPACK  SPPACK  SNPACK  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SNPACK,SPPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message, only : MessageNotify
  use w_base_module,  only : im, jm, nm
  use w_base_mpi_module,  only : jc
  use wa_base_mpi_module, only : xva_wa, wa_xva
  use w_deriv_mpi_module, only : w_JacobianMPI_w_w

  implicit none

  private
  private im, jm, nm                          ! Intel Fortran к
 
  public xva_GradLon_wa, xva_GradLat_wa       ! ۷ʬ
  public wa_DivLon_xva, wa_DivLat_xva         ! ȯʬ
  public wa_Div_xva_xva                       ! ȯʬ
  public wa_JacobianMPI_wa_wa                 ! 䥳ӥ
  public xva_GradLambda_wa, xva_GradMu_wa     ! ۷ʬ(,̺ɸ)
  public wa_DivLambda_xva, wa_DivMu_xva       ! ȯʬ(,̺ɸ)

  contains

  !--------------- ʬ׻ -----------------

    function xva_GradLon_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ

      real(8)              :: xva_GradLon_wa(im,jc,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xva_GradLon_wa = xva_wa(wa_data,ipow=1,iflag=-1)
    end function xva_GradLon_wa

    function xva_GradLat_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ

      real(8)              :: xva_GradLat_wa(im,jc,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xva_GradLat_wa = xva_wa(wa_data,ipow=1,iflag=1)
    end function xva_GradLat_wa

    function wa_DivLon_xva(xva_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xva_data(:,:,:)
      !(in) ϳʻǡ

      real(8)              :: wa_DivLon_xva((nm+1)*(nm+1),size(xva_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLon_xva = wa_xva(xva_data,ipow=1,iflag=-1)
    end function wa_DivLon_xva

    function wa_DivLat_xva(xva_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(¿).
      !

      real(8), intent(in)  :: xva_data(:,:,:)
      !(in) ϳʻǡ

      real(8)              :: wa_DivLat_xva((nm+1)*(nm+1),size(xva_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLat_xva = wa_xva(xva_data,ipow=1,iflag=1)
    end function wa_DivLat_xva

    function wa_Div_xva_xva(xva_u,xva_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(¿).
      !
      real(8), intent(in)  :: xva_u(:,:,:)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xva_v(:,:,:)
      !(in) ٥ȥʬγʻǡ

      real(8)              :: wa_Div_xva_xva((nm+1)*(nm+1),size(xva_u,3))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      wa_Div_xva_xva = wa_DivLon_xva(xva_u) + wa_DivLat_xva(xva_v)
    end function wa_Div_xva_xva

    function wa_JacobianMPI_wa_wa(wa_a,wa_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(¿).
      !
      real(8), intent(in) :: wa_a(:,:)
      !(in) 1ܤϥڥȥǡ

      real(8), intent(in) :: wa_b(:,:)
      !(in) 2ܤϥڥȥǡ

      real(8)             :: wa_JacobianMPI_wa_wa((nm+1)*(nm+1),size(wa_a,2))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      integer :: k

      do k=1,size(wa_a,2)
         wa_JacobianMPI_wa_wa(:,k) = w_JacobianMPI_w_w(wa_a(:,k),wa_b(:,k))
      end do
    end function wa_JacobianMPI_wa_wa


  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xva_GradLambda_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8)              :: xva_GradLambda_wa(im,jc,size(wa_data,2))
      !(in) ϥڥȥǡ

      xva_GradLambda_wa = xva_wa(wa_data,ipow=0,iflag=-1)
    end function xva_GradLambda_wa

    function xva_GradMu_wa(wa_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(¿).
      !
      real(8), intent(in)  :: wa_data(:,:)
      !(in) ϥڥȥǡ

      real(8)              :: xva_GradMu_wa(im,jc,size(wa_data,2))
      !(out) ڥȥǡ۷ʬʻǡ

      xva_GradMu_wa = xva_wa(wa_data,ipow=0,iflag=1)
    end function xva_GradMu_wa

    function wa_DivLambda_xva(xva_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(¿).
      !
      real(8), intent(in)  :: xva_data(:,:,:)
      !(in) ϳʻǡ

      real(8)              :: wa_DivLambda_xva((nm+1)*(nm+1),size(xva_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivLambda_xva = wa_xva(xva_data,ipow=2,iflag=-1)
    end function wa_DivLambda_xva

    function wa_DivMu_xva(xva_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(¿).
      !

      real(8), intent(in)  :: xva_data(:,:,:)
      !(in) ϳʻǡ

      real(8)              :: wa_DivMu_xva((nm+1)*(nm+1),size(xva_data,3))
      !(out) ʻǡȯʬڥȥǡ

      wa_DivMu_xva = wa_xva(xva_data,ipow=2,iflag=1)
    end function wa_DivMu_xva

end module wa_deriv_mpi_module
