!--
!----------------------------------------------------------------------
!   COPYRIGHT (c) 2006 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_galerkin_module
!
!      2 ϩΰ
!      Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
!
!  2006/01/24  ݹ  
!      2006/02/28  ݹ  Ȥ RDoc Ѥѹ
!
!++
module et_galerkin_module
  !
  != et_galerkin_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: et_galerkin_module.f90,v 1.3 2009-02-28 21:33:46 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/et_galerkin_module ⥸塼 2 ͥΰǤήαư
  ! 򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ󶡤.
  ! Ūʶ򰷤 X ؤΥաꥨѴ, 
  ! ɤ򰷤 Y ΥӥѴ(ӥա顼ˡ)
  ! Υڥȥ׻ΤΤޤޤʴؿ󶡤
  !
  !  et_module, Ӷ򤯤˥ӥա顼ˡ
  ! ⥸塼뷲(at_ab_galerkin_ND, at_ad_galerkin_DD, at_af_galerkin_MM,
  ! at_ah_galerkin_MMex, at_ap_galerkin_DN, at_aq_galerkin_RRSS,
  ! at_av_galerkin_NN) ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  ! ......
  !
  use dc_message
  use lumatrix
  use et_module
  use at_ad_galerkin_DD, only: at_ad_galerkin_DD_Initial,      &
                               ed_et => ad_at, et_ed => at_ad, &
                               ed_eg => ad_ag, eg_ed => ag_ad, &
                               ed_Dx_ed => ad_Dx_ad,           &
                               d_t, t_d, d_g, g_d, d_Dx_d
  use at_av_galerkin_NN, only: at_av_galerkin_NN_Initial,      &
                               ev_et => av_at, et_ev => at_av, &
                               ev_eg => av_ag, eg_ev => ag_av, &
                               ev_Dx_ev => av_Dx_av,           &
                               v_t, t_v, v_g, g_v, v_Dx_v
  use at_ab_galerkin_ND, only: at_ab_galerkin_ND_Initial,      &
                               eb_et => ab_at, et_eb => at_ab, &
                               eb_eg => ab_ag, eg_eb => ag_ab, &
                               eb_Dx_eb => ab_Dx_ab,           &
                               b_t, t_b, b_g, g_b, b_Dx_b
  use at_ap_galerkin_DN, only: at_ap_galerkin_DN_Initial,      &
                               ep_et => ap_at, et_ep => at_ap, &
                               ep_eg => ap_ag, eg_ep => ag_ap, &
                               ep_Dx_ep => ap_Dx_ap,           &
                               p_t, t_p, p_g, g_p, p_Dx_p
  use at_af_galerkin_MM, only: at_af_galerkin_MM_Initial,      &
                               ef_et => af_at, et_ef => at_af, &
                               ef_eg => af_ag, eg_ef => ag_af, &
                               ef_Dx_ef => af_Dx_af,           &
                               f_t, t_f, f_g, g_f, f_Dx_f
  use at_ah_galerkin_MMex, only: at_ah_galerkin_MMex_Initial,    &
                                 eh_et => ah_at, et_eh => at_ah, &
                                 eh_eg => ah_ag, eg_eh => ag_ah, &
                                 eh_Dx_eh => ah_Dx_ah
  use at_aq_galerkin_RRSS, only: at_aq_galerkin_RRSS_Initial,    &
                                 eq_et => aq_at, et_eq => at_aq, &
                                 eq_eg => aq_ag, eg_eq => ag_aq, &
                                 eq_Dx_eq => aq_Dx_aq,           &
                                 q_t, t_q, q_g, g_q, q_Dx_q,     &
                                 TQ, QT, alpha, beta

  implicit none
  private

  public et_galerkin_Initial                              ! 
  public eq_Vor2Strm_et                                   ! ->ή

  !-- et_module 
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ
  public yx_et, et_yx                                     ! Ѵ
  public e_x, x_e, ae_ax, ax_ae                           ! Ѵ
  public t_y, y_t, at_ay, ay_at                           ! Ѵ

  public et_Dx_et, e_Dx_e, ae_Dx_ae                       ! ʬ
  public et_Dy_et, t_Dy_t, at_Dy_at                       ! ʬ
  public et_Lapla_et                                      ! ʬ

  public et_Jacobian_et_et                                ! ׻

  !-- at_ad_galerkin_DD
  public :: ed_et, d_t                 ! ӥ->顼Ѵ
  public :: ed_eg, d_g                 ! ʻ->顼ǡѴ
  public :: et_ed, t_d                 ! 顼->ӥѴ
  public :: eg_ed, g_d                 ! 顼->ʻǡѴ
  public :: ed_Dx_ed, d_Dx_d           ! X ʬ

  !-- at_av_galerkin_NN
  public :: ev_et, v_t                 ! ӥ->顼Ѵ
  public :: ev_eg, v_g                 ! ʻ->顼ǡѴ
  public :: et_ev, t_v                 ! 顼->ӥѴ
  public :: eg_ev, g_v                 ! 顼->ʻǡѴ
  public :: ev_Dx_ev, v_Dx_v           ! X ʬ

  !-- at_ab_galerkin_ND
  public :: eb_et, b_t                 ! ӥ->顼Ѵ
  public :: eb_eg, b_g                 ! ʻ->顼ǡѴ
  public :: et_eb, t_b                 ! 顼->ӥѴ
  public :: eg_eb, g_b                 ! 顼->ʻǡѴ
  public :: eb_Dx_eb, b_Dx_b           ! X ʬ

  !-- at_ap_galerkin_DN
  public :: ep_et, p_t                 ! ӥ->顼Ѵ
  public :: ep_eg, p_g                 ! ʻ->顼ǡѴ
  public :: et_ep, t_p                 ! 顼->ӥѴ
  public :: eg_ep, g_p                 ! 顼->ʻǡѴ
  public :: ep_Dx_ep, p_Dx_p           ! X ʬ

  !-- at_af_galerkin_MM
  public :: ef_et, f_t                 ! ӥ->顼Ѵ
  public :: ef_eg, f_g                 ! ʻ->顼ǡѴ
  public :: et_ef, t_f                 ! 顼->ӥѴ
  public :: eg_ef, g_f                 ! 顼->ʻǡѴ
  public :: ef_Dx_ef, f_Dx_f           ! X ʬ

  !-- at_ab_galerkin_MMex
  public :: eh_et                      ! ӥ->顼Ѵ
  public :: eh_eg                      ! ʻ->顼ǡѴ
  public :: et_eh                      ! 顼->ӥѴ
  public :: eg_eh                      ! 顼->ʻǡѴ
  public :: eh_Dx_eh                   ! X ʬ

  !-- at_aq_galerkin_RRSS
  public :: eq_et, q_t                 ! ӥ->顼Ѵ
  public :: eq_eg, q_g                 ! ʻ->顼ǡѴ
  public :: et_eq, t_q                 ! 顼->ӥѴ
  public :: eg_eq, g_q                 ! 顼->ʻǡѴ
  public :: eq_Dx_eq, q_Dx_q           ! X ʬ


  !-- ѿ--
  integer :: im=128, jm=64               ! ʻ(X,Y)
  integer :: km=42,  lm=42               ! ȿ(X,Y)

  logical :: Set_DD    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_NN    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_DN    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_ND    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_MM    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_MMex  =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_RRSS  =.false.        ! ⥸塼ɤ߹ߥå

  save im, jm, km, lm, &
       Set_DD, Set_NN, Set_DN, Set_ND, Set_MM, Set_MMex, Set_RRSS

  contains
  !---------------  -----------------
    subroutine et_galerkin_Initial(i,j,k,l,xmin,xmax,ymin,ymax,&
         DD,NN,DN,ND,velBC,&
         MM_cfdx0_xmin, MM_cfdx1_xmin, MM_cfdx0_xmax, MM_cfdx1_xmax,&
         MMex_cfdx0_xmin, MMex_cfdx1_xmin, MMex_cfdx0_xmax, MMex_cfdx1_xmax)
      !
      !  2 ϩΰ
      !  Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
      !
      !  ֥롼
      !
      integer,intent(in) :: i, j           ! ʻ(X,Y)
      integer,intent(in) :: k, l           ! ȿ(X,Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      logical,intent(in),optional :: DD  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: NN  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: DN  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: ND  ! ⥸塼ɤ߹ߥå

      ! at_af_galerkin_MM_module ﷸ
      real(8),intent(in),optional :: MM_cfdx0_xmin ! (0ʬ@x=xmin)
      real(8),intent(In),optional :: MM_cfdx1_xmin ! (1ʬ@x=xmin)
      real(8),intent(in),optional :: MM_cfdx0_xmax ! (0ʬ@x=xmax)
      real(8),intent(in),optional :: MM_cfdx1_xmax ! (1ʬ@x=xmax)

      ! at_ah_galerkin_MMex_module ﷸ
      real(8),intent(in),optional :: MMex_cfdx0_xmin(-k:k) ! (0ʬ@x=xmin)
      real(8),intent(in),optional :: MMex_cfdx1_xmin(-k:k) ! (1ʬ@x=xmin)
      real(8),intent(in),optional :: MMex_cfdx0_xmax(-k:k) ! (0ʬ@x=xmax)
      real(8),intent(in),optional :: MMex_cfdx1_xmax(-k:k) ! (1ʬ@x=xmax)

      ! at_aq_galerkin_RRSS_module ®پ춭
      character(LEN=2),intent(in),optional :: velBC  ! (RR/SS/RS/SR)

      !---------------  -----------------
      im=i ; jm = j ; km=k ; lm=l

      if ( present(DD) ) Set_DD = DD
      if ( present(NN) ) Set_NN = NN
      if ( present(DN) ) Set_DN = DN
      if ( present(ND) ) Set_ND = ND

      if ( present(MM_cfdx0_xmin) .AND.present(MM_cfdx1_xmin) .AND.&
           present(MM_cfdx0_xmax) .AND.present(MM_cfdx1_xmax) ) &
           Set_MM=.true.

      if ( present(MMex_cfdx0_xmin) .AND.present(MMex_cfdx1_xmin) .AND.&
           present(MMex_cfdx0_xmax) .AND.present(MMex_cfdx1_xmax) ) &
           Set_MMex=.true.

      if ( present(velBC) ) Set_RRSS = .true.

      !--------------- ⥸塼 -----------------
      call et_Initial(im,jm,km,lm,xmin,xmax,ymin,ymax)
      if ( Set_DD ) call at_ad_galerkin_DD_Initial(jm,lm)
      if ( Set_NN ) call at_av_galerkin_NN_Initial(jm,lm)
      if ( Set_DN ) call at_ap_galerkin_DN_Initial(jm,lm)
      if ( Set_ND ) call at_ab_galerkin_ND_Initial(jm,lm)
      if ( Set_MM ) call at_af_galerkin_MM_Initial      &
                               (jm,lm, MM_cfdx0_xmax, MM_cfdx1_xmax,&
                                       MM_cfdx0_xmin, MM_cfdx1_xmin   )
      if ( Set_MMex ) call at_ah_galerkin_MMex_Initial      &
                               (jm,lm,2*km+1, &
                                MMex_cfdx0_xmax, MMex_cfdx1_xmax,&
                                MMex_cfdx0_xmin, MMex_cfdx1_xmin   )

      if ( Set_RRSS ) call at_aq_galerkin_RRSS_Initial(jm,lm,velBC)

    end subroutine et_galerkin_initial

   !------------------- ٤ή ----------------------
    function eq_Vor2Strm_et(et_Zeta)
      !
      !  2 ϩΰ
      !  Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
      !
      !  ٤ή׻.
      !
      real(8), intent(IN) :: et_Zeta(-km:km,0:lm)        !(in)   =^2
      real(8)             :: eq_Vor2Strm_et(-km:km,4:lm) !(out) ή 

      real(8), allocatable :: LaplaMT(:,:,:)
      real(8), allocatable :: LaplaInvMT(:,:,:)
      integer, allocatable :: kpvot(:,:)

      integer, parameter :: ls=4

      real(8) :: eq_work(-km:km,ls:lm)
      real(8) :: et_work(-km:km,0:lm)

      integer :: k, m, n, l, p
      logical :: first = .true.
      save LaplaInvMT, kpvot, first

      if ( .not. Set_RRSS ) &
           call MessageNotify('E','eq_Vor2Strm_et',&
                    'at_aq_galerkin_RRSS_module not initialized.')

      if ( first ) then
         first = .false.
         allocate(LaplaMT(-km:km,0:lm,0:lm))
         allocate(LaplaInvMT(-km:km,ls:lm,ls:lm),kpvot(-km:km,ls:lm))

         LaplaMT=0.0D0
         do l=0,lm
            et_work = 0.0D0 ; et_work(:,l) = 1.0D0
            et_work = et_Lapla_et(et_work)
            LaplaMT(:,:,l) = et_work
         enddo

         LaplaInvMT=0.0
         do n=ls,lm
            do m=ls,lm
               do l=0,lm
                  do p=0,lm
                     LaplaInvMT(:,n,m)=LaplaInvMT(:,n,m) &
                          +TQ(l,n)*LaplaMT(:,l,p)*alpha(p)*TQ(p,m)
                  enddo
               enddo
            enddo
         enddo

         call LUDecomp(LaplaInvMT,kpvot)
         deallocate(LaplaMT)
      endif

      eq_work=0.0
      do m=ls,lm
         do k=0,lm
            eq_work(:,m)=eq_work(:,m) &
                 + alpha(k) * beta(k) * et_Zeta(:,k)* TQ(k,m) 
         enddo
      enddo

      eq_Vor2Strm_et = LUSolve(LaplaInvMT,kpvot,eq_work)

    end function eq_Vor2Strm_et

end module et_galerkin_module
