!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  aq_module ƥȥץ
!
!  2008/04/02  ݹ
!
program aq_intavr

  use dc_message, only : MessageNotify
  use aq_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, km=31       ! ʻ, ȿ
  real(8), parameter :: ra=2               ! ΰ礭

  integer, parameter :: lm=2               ! ȿ

 !---- ѿ ----
  real(8)            :: g_Data(im)     ! ʻҥǡ
  real(8)            :: ag_Data(lm,im)    ! ʻҥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: alpha=0.5D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta= 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 
  real(8), parameter :: gamma=2*alpha+beta ! Ÿ¿༰ѥ᥿ 
  real(8), parameter :: eps=1.0D-6

  real(8) :: gammaln
  external gammaln

  real(8) :: Intsol, Avrsol
  real(8) :: a_Intsol(lm), a_Avrsol(lm)

 !---------------- ɸͤ ---------------------

  call aq_Initial(im,km,ra,alpha,beta,(/0/))

  write(6,*)'+++++ Test of Int_g, Avr_g +++++'

  !  W(R) = R^beta/(a^2-R^2)^(1-alpha)
  !
  !  \int_0^a R^n W(R) dR 
  !       = a^{n+gamma-1} \int_0^1 r^(n+beta) (1-r^2)^(alpha-1) dr
  !       = (1/2) a^{n+gamma-1}((n+beta+1)/2)(alpha)/(alpha+(n+beta+1)/2)
  !
  !  \int_0^1 r^n w(r) dr = \int_0^1 r^(n+beta) (1-r^2)^(alpha-1) dr
  !                   = (1/2)\int_0^1 t^{(n+beta-1)/2} (1-t)^(alpha-1) dt
  !                   = (1/2) B((n+beta+1)/2,alpha)
  !                   = (1/2) ((n+beta+1)/2)(alpha)/(alpha+(n+beta+1)/2)
  !

  g_Data = 1
  Intsol = ra**(gamma-1)/2 &
             * exp(gammaln(alpha))&
             *exp(gammaln((beta+1)/2))/exp(gammaln(alpha+(Beta+1)/2))
  Avrsol = 1

  write(6,*) 'f = 1'

  call check0d(Int_g(g_Data) - Intsol, eps, 'Int_g')
  call check0d(Avr_g(g_Data) - Avrsol, eps, 'Avr_g')

  g_Data = g_R**2
  Intsol = ra**(2+gamma-1)/2 &
       * exp(gammaln(alpha)) &
       * exp(gammaln((2+beta+1)/2))/exp(gammaln(alpha+(2+Beta+1)/2))
  Avrsol = Intsol/(ra**(gamma-1)/2 &
                   * exp(gammaln(alpha))&
                   * exp(gammaln((beta+1)/2))/exp(gammaln(alpha+(Beta+1)/2)))

  write(6,*) 'f = r**2'

    call check0d(Int_g(g_Data) - Intsol, eps, 'Int_g')
    call check0d(Avr_g(g_Data) - Avrsol, eps, 'Avr_g')

  call MessageNotify('M','Test of Int_g, Avr_g', &
       'Test of Int_g, Avr_g suceeded!')

  write(6,*)
  write(6,*)'+++++ Test of a_Int_ag, a_Avr_ag +++++'

  call aq_Initial(im,km,ra,alpha,beta,(/2,1/))

  ag_Data(1,:) = g_R**4
  ag_Data(2,:) = g_R**5

  a_IntSol(1) =  ra**(4+gamma-1)/2 &
                  * exp(gammaln(alpha)) & 
                  * exp(gammaln((4+beta+1)/2))/exp(gammaln(alpha+(4+Beta+1)/2))
  a_IntSol(2) =  ra**(5+gamma-1)/2 &
                  * exp(gammaln(alpha)) &
                  * exp(gammaln((5+beta+1)/2))/exp(gammaln(alpha+(5+Beta+1)/2))
  a_AvrSol = a_IntSol/(ra**(gamma-1)/2 &
                  * exp(gammaln(alpha)) &
                  * exp(gammaln((beta+1)/2))/exp(gammaln(alpha+(Beta+1)/2)))

  write(6,*) 'f = g_R**4, g_R**5'

    call check1d(a_Int_ag(ag_Data) - a_Intsol, eps, 'a_Int_ag')
    call check1d(a_Avr_ag(ag_Data) - a_Avrsol, eps, 'a_Avr_ag')

  call MessageNotify('M','Test of a_Int_ag, a_Avr_ag', &
       'Test of a_Int_ag, a_Avr_ag suceeded!')

stop
contains

  subroutine check1d(var,eps,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:)                  ! Ƚꤹ
    real(8) :: eps                     ! 
    character(len=*), optional :: funcname
    integer i

    if ( present(funcname) )then
       write(6,*) '  Checking ', funcname, '...'
    endif

    do i=1,size(var)
       if (abs(var(i)) .gt. eps ) then
          write(6,*) '    Value larger than EPS : i= ', i, var(i)
          call MessageNotify('E','Test of '//funcname, 'Error too large.')
       endif
    enddo
  end subroutine check1d

  subroutine check0d(var,eps,funcname)   ! var ͤ eps ʾȽ
    real(8) :: var                       ! Ƚꤹ
    real(8) :: eps                       ! 
    real(8) :: vartmp(1)                 ! 
    character(len=*), optional :: funcname

    vartmp(1) = var
    if ( present(funcname) ) then
       call check1d(vartmp,eps,funcname)
    else
       call check1d(vartmp,eps)
    endif
  end subroutine check0d

end program aq_intavr
