!----------------------------------------------------------------------
!     COPYRIGHT (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B
!      2007/10/25  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program at_test_base1d

  use dc_message, only : MessageNotify
  use at_module
  implicit none
  integer, parameter :: im=4, km=4
  real(8), parameter :: xmin=-1.0D0, xmax=1.0D0
  real(8), parameter :: eps=1.0D-14

  real(8), dimension(0:im) :: g_z
  real(8), dimension(0:km) :: t_z
  real(8), dimension(0:km) :: t_z_sol

  write(6,*)'++++++ Testing basic functions t_g, g_t, t_Dx_t +++++'

  call at_initial(im,km,xmin,xmax)

  g_z = 2*g_x**2 - 1
  write(6,*) 'z = T_2(x)'
  t_z = t_g(g_z)
  write(6,*) 'Calculated values are ', t_z
  t_z_sol = 0.0 ; t_z_sol(2) = 1.0d0
  if ( maxval(abs(t_z_sol-t_z)) > eps )then
     call MessageNotify('E','Test of t_g', &
          'Transform error too large.')
  endif

  write(6,*) 'g_t(t_g(z)) - z = 0'
  write(6,*) 'Max.val of calculated values is ', maxval(abs(g_t(t_z)- g_z))
  if ( maxval(abs(g_t(t_z)- g_z)) > eps )then
     call MessageNotify('E','Test of g_t', &
          'Transform error too large.')
  endif

  write(6,*) 'g_t(t_dx_t(t_g(z))) - 4*g_x = 0'
  write(6,*) 'Max.val of calculated values are ',&
       maxval(abs(g_t(t_dx_t(t_z)) - 4*g_x))
  if ( maxval(abs(g_t(t_dx_t(t_z)) - 4*g_x)) > eps )then
     call MessageNotify('E','Test of t_dx_t', &
          'Differentiation error too large.')
  endif

  g_z = 8*g_x**4 - 8*g_x**2 + 1
  write(6,*) 
  write(6,*) 'z = T_4(x)'
  t_z = t_g(g_z)
  write(6,*) 'Calculated values are', t_z
  t_z_sol = 0.0
  t_z_sol(4) = 2.0d0

  if ( maxval(abs(t_z_sol-t_z)) > eps )then
     call MessageNotify('E','Test of t_g', &
          'Transform error too large.')
  endif

  write(6,*) 'g_t(t_g(z)) - z = 0'
  write(6,*) 'Max.val of calculated values are ', maxval(abs(g_t(t_z)- g_z))
  if ( maxval(abs(g_t(t_z)- g_z)) > eps )then
     call MessageNotify('E','Test of g_t', &
          'Transform error too large.')
  endif

  write(6,*) 'g_t(t_dx_t(t_g(z))) - ( 32*g_x**3 - 16 * g_x ) = 0'
  write(6,*) 'Max.val of calculated values are ', &
       maxval(abs(g_t(t_dx_t(t_z)) - ( 32*g_x**3 - 16 * g_x )))
  if ( maxval(abs(g_t(t_dx_t(t_z)) - ( 32*g_x**3 - 16 * g_x ))) > eps )then
     call MessageNotify('E','Test of t_dx_t', &
          'Differentiation error too large.')
  endif

  call MessageNotify('M','Test of g_t, t_g, t_Dx_t', &
       'Tests of basic functions g_t, t_g, t_Dx_t suceeded!')

end program at_test_base1d
