!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B 
!      2007/10/25  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program at_test_weight

  use dc_message, only : MessageNotify
  use at_module
  implicit none
  integer, parameter :: im=32, km=32
  real(8), parameter :: xmin=0.0D0, xmax=2.0D0
  real(8), parameter :: eps=1.0D-10

  real(8), dimension(0:im) :: g_z
  real(8), parameter       :: pi=3.1415926535897932385D0

  integer :: i

  write(6,*)'++++++ Testing g_X_Weight +++++'

do i=1,2
  call at_initial(im,km/i,xmin,xmax)

!!$  write(6,*) 'x'
!!$  write(6,*) g_x
!!$  write(6,*) 
!!$  write(6,*) 'x weight'
!!$  write(6,*) g_x_weight

  g_z(:) = 1
  write(6,*) 
  write(6,*) 'z = 1, int_0^2 z dx = ', 2.0
  write(6,*) 'Calculated value is   ', sum(g_z*g_x_weight)
  if ( abs(sum(g_z*g_x_weight)-2) > eps )then
     call MessageNotify('E','Test of g_X_Weight', &
          'Integration error too large.')
  endif

  g_z(:) = g_x**2
  write(6,*) 
  write(6,*) 'z = x**2, int_0^2 z dx = ', 8.0/3d0
  write(6,*) 'Calculated value is      ',sum(g_z*g_x_weight)
  if ( abs(sum(g_z*g_x_weight)-8.0d0/3.0d0) > eps )then
     call MessageNotify('E','Test of g_X_Weight', &
          'Integration error too large.')
  endif

  write(6,*) 
  write(6,*) 'z = sin(pi*x/2), int_0^2 z dx = ', 4.0/pi
  g_z(:) = sin(pi*g_x/2)
  write(6,*) 'Calculated value is             ',sum(g_z*g_x_weight)
  if ( abs(sum(g_z*g_x_weight)-4.0d0/pi) > eps )then
     call MessageNotify('E','Test of g_X_Weight', &
          'Integration error too large.')
  endif

end do

  call MessageNotify('M','Test of g_X_Weight', &
       'Test of g_X_Weight suceeded!')

end program at_test_weight



