!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_zonal_module ƥȥץ :: ڥȥϴؿΥƥ
!
!  2008/12/28  ݹ
!
program w_zonal_test_spectrum

  use dc_message, only : MessageNotify
  use w_zonal_module
  implicit none

  integer, parameter :: im=1, jm=8, nm=10

  real(8), dimension(nm+1)        ::  w_data
  real(8), dimension(0:im-1,1:jm) ::  xy_data

  real(8), dimension(0:nm,-nm:nm) ::  nm_data
  real(8), dimension(0:nm)        ::  n_data
  real(8)                         ::  data

  real(8), parameter            ::  eps = 1.0D-10

  real(8) :: error
  integer :: n,m

  call w_Initial( nm, im, jm )

  call MessageNotify('M','w_test_spectrum','w_spectrum_module tests') 

  !================= 2Y_1^0+3Y_2^0 Υƥ ================
  xy_data = 2*sqrt(3.0D0)*sin(xy_Lat) &                  ! 2Y_1^0+3Y_2^0
          + 3*sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)
  w_data = w_xy(xy_data)

  !--------- Energy spectrum ---------
  nm_data=w_spectrum_VMiss
  do n=0,nm
     do m=-n,n
        nm_data(n,m) = 0.0
     enddo
  enddo
  nm_data(1,0) = 4.0D0 ;   nm_data(2,0) = 27.0D0
  error = maxval(abs(nm_EnergyFromStreamfunc_w(w_data)-nm_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of nm_EnergyFromStreamFunc',&
                        '2Y_1^0+3Y_2^0 Energy error too large') 
  endif
  call MessageNotify('M','Test of nm_EnergyFromStreamFunc', &
       'Test of 2Y_1^0+3Y_2^1 succeeded!') 

  n_data = 0.0; n_data(1) = 4.0D0 ;   n_data(2) = 27.0D0
  error = maxval(abs(n_EnergyFromStreamfunc_w(w_data)-n_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of n_EnergyFromStreamFunc',&
                        '2Y_1^0+3Y_2^0 Energy error too large') 
  endif
  call MessageNotify('M','Test of n_EnergyFromStreamFunc', &
       'Test of 2Y_1^0+3Y_2^0 succeeded!') 

  data = AvrLonLat_xy( 0.5*(xy_GradLon_w(w_data)**2+xy_GradLat_w(w_data)**2) )
  error = abs(sum(n_EnergyFromStreamfunc_w(w_data))-data)
  if ( error > eps ) then
     call MessageNotify('E','Test of total energy',&
                        '2Y_1^0+3Y_2^0 total energy error too large') 
  endif
  call MessageNotify('M','Test of total energy', &
       'Test of 2Y_1^0+3Y_2^0 succeeded!') 

  !--------- Enstrophy spectrum ---------
  nm_data=w_spectrum_VMiss
  do n=0,nm
     do m=-n,n
        nm_data(n,m) = 0.0
     enddo
  enddo
  nm_data(1,0) = 8.0D0 ;   nm_data(2,0) = 162.0D0
  error = maxval(abs(nm_EnstrophyFromStreamfunc_w(w_data)-nm_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of nm_EnstrophyFromStreamFunc',&
                        '2Y_1^0+3Y_2^0 Enstrophy error too large') 
  endif
  call MessageNotify('M','Test of nm_EnstrophyFromStreamFunc', &
       'Test of 2Y_1^0+3Y_2^1 succeeded!') 

  n_data = 0.0; n_data(1) = 8.0D0 ;   n_data(2) = 162.0D0
  error = maxval(abs(n_EnstrophyFromStreamfunc_w(w_data)-n_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of n_EnstrophyFromStreamFunc',&
                        '2Y_1^0+3Y_2^0 Enstrophy error too large') 
  endif
  call MessageNotify('M','Test of n_EnstrophyFromStreamFunc', &
       'Test of 2Y_1^0+3Y_2^1 succeeded!') 

  data = AvrLonLat_xy( 0.5*(xy_w(w_Lapla_w(w_data))**2))
  error = abs(sum(n_EnstrophyFromStreamfunc_w(w_data))-data)
  if ( error > eps ) then
     call MessageNotify('E','Test of total enstrophy',&
                        '2Y_1^0+3Y_2^0 total enstrophy error too large') 
  endif
  call MessageNotify('M','Test of total enstrophy', &
       'Test of 2Y_1^0+3Y_2^1 succeeded!') 

end program w_zonal_test_spectrum
