!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  at_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/04/10  $BC]9-??0l(B
!      2007/10/25  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program at_test_base2d

  use dc_message, only : MessageNotify
  use at_module
  implicit none
  integer, parameter :: im=8, km=5, nm=4
  real(8), parameter :: xmin=-1.0D0, xmax=1.0D0
  real(8), parameter :: eps=1.0D-10

  real(8), dimension(0:nm,0:im) :: ag_y
  real(8), dimension(0:nm,0:im) :: ag_y_orig
  real(8), dimension(0:nm,0:im) :: ag_y_deriv

  integer :: i, m

  write(6,*)'++++++ Testing basic functions at_ag, ag_at, at_Dx_at +++++'

  call at_initial(im,km,xmin,xmax)

  ag_y(0,:) = 1                          ! T_0
  ag_y(1,:) = g_x                        ! T_1
  ag_y(2,:) = 2*g_x**2 - 1               ! T_2
  ag_y(3,:) = 4*g_x**3 - 3*g_x           ! T_3
  ag_y(4,:) = 8*g_x**4 - 8*g_x**2 + 1
  ag_y_deriv(0,:) = 0.0D0                 ! T_0'= 0
  ag_y_deriv(1,:) = 1.0D0                 ! T_1'= T_0
  ag_y_deriv(2,:) = 4*g_x                 ! T_2'= 4*T_1
  ag_y_deriv(3,:) = 12*g_x**2 - 3         ! T_3'= 6*T_2 + 3*T_0
  ag_y_deriv(4,:) = 32*g_x**3 - 16*g_x    ! T_4'= 8*T_3 + 8*T_1

  ag_y_orig = ag_y
  ag_y = ag_at(at_ag(ag_y))

  write(6,*) 'y(n)=T_n(x), n=0...4'
  write(6,*) 'Test of at_ag, ag_at'
  write(6,*) 'wrong values are displayed below...'
  do m=0,nm
     do i=0,im
        if ( abs(ag_y(m,i)-ag_y_orig(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_y(m,i), ag_y_orig(m,i), ag_y(m,i)-ag_y_orig(m,i)
           call MessageNotify('E','Test of ag_at,at_ag', &
                'Transformation error too large.')
        endif
     enddo
  enddo
  
  write(6,*) 'Test of at_Dx_at'
  ag_y = ag_at(at_dx_at(at_ag(ag_y)))
  write(6,*) 'wrong values are displayed below...'
  do m=0,nm
     do i=0,im
        if ( abs(ag_y(m,i)-ag_y_deriv(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_y(m,i), ag_y_deriv(m,i), ag_y(m,i)-ag_y_deriv(m,i)
           call MessageNotify('E','Test of at_Dx_at', &
                'Differentiation error too large.')
        endif
     enddo
  enddo

  call MessageNotify('M','Test of ag_at, at_ag, at_Dx_at', &
       'Tests of basic functions ag_at, at_ag, at_Dx_at suceeded!')

end program at_test_base2d

