!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!     ֥롼Υƥ
!       wq_Potential2Rotation
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_derivative7

  use dc_message, only : MessageNotify
  use wq_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=8  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15        ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=7.0D0/13.0D0     ! ⳰Ⱦ \eta=0.35

  real(8), dimension((nm+1)*(nm+1),0:lm) :: wq_VTor    ! ȥݥƥ󥷥
  real(8), dimension((nm+1)*(nm+1),0:lm) :: wq_VPol    ! ݥݥƥ󥷥

  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotVLon  ! ()
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotVLat  ! ()
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotVrad  ! (ư)
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotV0Lon  ! (, )
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotV0Lat  ! (, )
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RotV0rad  ! (,ư)

  real(8), parameter :: eps = 5.0D-9

  integer :: i,j,k

  call MessageNotify('M','wq_test_derivative7', &
       'wq_module derivative subroutine test #7')

  call wq_Initial(im,jm,km,nm,lm,ra)

  write( 6,* ) 'Test for wq_Rotation'
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

! -----------------  1 --------------------
  ! βž
  wq_VTor = wq_xyr(xyr_Rad * sin(xyr_Lat))
  wq_VPol = 0.0D0

  ! xyr_Vlon = xyr_Rad * cos(xyr_Lat)'
  ! xyr_Vlat = 0.0'
  ! xyr_VRad = 0.0'

  xyr_RotV0lon = 0.0D0
  xyr_RotV0lat = 2*cos(xyr_LAT)
  xyr_RotV0rad = 2*sin(xyr_LAT)

  write(6,*)
  write(6,*)
  write(6,*)'Example 1 : rigid rotation'
  write(6,*)'    xyr_Vlon = xyr_Rad*cos(xyr_LAT)'
  write(6,*)'    xyr_Vlat = 0.0'
  write(6,*)'    xyr_VRad = 0.0'

  call checkresult

! -----------------  2 --------------------
  ! βž(ή)
  wq_VTor = wq_xyr(xyr_Rad * cos(xyr_Lat) * sin(xyr_Lon))
  wq_VPol = 0.0D0

  !  xyr_VLon = -xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)
  !  xyr_VLat = -xyr_Rad*cos(xyr_Lon)
  !  xyr_VRad = 0.0

  xyr_RotV0Lon = 2*cos(xyr_Lon)
  xyr_RotV0Lat = -2*sin(xyr_Lon)*sin(xyr_Lat)
  xyr_RotV0Rad = 2*sin(xyr_Lon)*cos(xyr_Lat)

  write(6,*)
  write(6,*)
  write(6,*)'Example 2 : rigid rotation'
  write(6,*)'    xyr_Vlon=xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)'
  write(6,*)'    xyr_Vlat=-xyr_Rad*cos(xyr_Lon)'
  write(6,*)'    xyr_VRad = 0.0'

  call checkresult

! -----------------  3 --------------------
 ! ̵

  wq_VTor = 0.0D0
  wq_VPol = wq_xyr(xyr_Rad * sin(xyr_Lat))

  ! xyr_Vlon = 0
  ! xyr_Vlat = 2 * cos(xyr_Lat)
  ! xyr_Vrad = 2 * sin(xyr_Lat)

  xyr_RotV0lon = 0.0D0
  xyr_RotV0lat = 0.0D0
  xyr_RotV0rad = 0.0D0

  write(6,*)
  write(6,*)
  write(6,*)'Example 3 : no rotation'
  write(6,*)'    xyr_Vlon = 0.0'
  write(6,*)'    xyr_Vlat = 2 * cos(xyr_Lat)'
  write(6,*)'    xyr_Vrad = 2 * sin(xyr_Lat)'

  call checkresult

! -----------------  4 --------------------
 ! ݥ®پ

  wq_VTor = 0.0D0
  wq_VPol = wq_xyr(xyr_Rad **3 * cos(xyr_Lat)*sin(xyr_Lon))

  ! xyr_Vlon = 4 * xyr_Rad**2 * cos(xyr_Lon)
  ! xyr_Vlat = -4 * xyr_Rad**2 * sin(xyr_Lat) * sin(xyr_Lon)
  ! xyr_Vrad = 2 * xyr_Rad**2  * cos(xyr_Lat) * sin(xyr_Lon)

  xyr_RotV0lon = 10*xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)
  xyr_RotV0lat = 10*xyr_Rad*cos(xyr_Lon)
  xyr_RotV0rad = 0.0D0

  write(6,*)
  write(6,*)
  write(6,*)'Example 4 : poloidal field'
  write(6,*)'    xyr_Vlon = 4 * xyr_Rad**2 * cos(xyr_Lon)'
  write(6,*)'    xyr_Vlat =-4 * xyr_Rad**2 * sin(xyr_Lat) * sin(xyr_Lon)'
  write(6,*)'    xyr_VRad = 2 * xyr_Rad**2 * cos(xyr_Lat) * sin(xyr_Lon)'

  call checkresult

  call MessageNotify('M','wq_test_derivative7', &
       'wq_module derivative function test #7 succeeded!')

  stop
contains

 !-------  -------
  subroutine checkresult

    call wq_Potential2Rotation(&
         xyr_RotVLon,xyr_RotVLat,xyr_RotVRad, wq_VTor, wq_VPol )

    write(6,*)
    write(6,*)'Checking RotV_Lon '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_RotVLon(i,j,k)-xyr_RotV0Lon(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_RotVLon(i,j,k),xyr_RotV0Lon(i,j,k), &
                                  xyr_RotVLon(i,j,k)-xyr_RotV0Lon(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

    write(6,*)
    write(6,*)'Checking RotV_Lat '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_RotVLat(i,j,k)-xyr_RotV0Lat(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_RotVLat(i,j,k),xyr_RotV0Lat(i,j,k),&
                                  xyr_RotVLat(i,j,k)-xyr_RotV0Lat(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

    write(6,*)
    write(6,*)'Checking RotV_Rad '
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_RotVRad(i,j,k)-xyr_RotV0Rad(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_RotVRad(i,j,k),xyr_RotV0rad(i,j,k),&
                                  xyr_RotVRad(i,j,k)-xyr_RotV0rad(i,j,k)
                call MessageNotify('E','wq_test_derivative7', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

  end subroutine checkresult

end program wq_test_derivative7
