= begin EN

# yot, 2015/04/29

= Summary

本プログラムは DCPAM 出力の NetCDF ファイルを paraview で使いやすい
形式に変換します. 
実際に行っていることは, lon, lat, sig, sigm 軸の属性を削除し, sig, 
sigm の値を sig* = (1-sig)*100, sigm* = (1-sigm*)*100 に変更します
(sig*, sigm* は変更後の座標値).

This program changes DCPAM output files to files that can be used 
by paraview easily. 
What is done is as follows:
  * delete attribute of lon, lat, sig, sigm axes,
  * change values of sig and sigm to (1-sig)*100 and (1-sigm)*100, respectively.

= Usage

== Required library

* NetCDF

== Compilation

* Edit Makefile
  * Change following items
    * FC: Fortran compiler
    * FOPT : Option for Fortran compiler
    * NCDIR : a path to NetCDF library
* make
  % make

== Execution

* Edit configuration file, file.conf
* Execute as follows.
  % mkncforparaview

= Configuration file

This program read a configuration file when it is executed. 
The name of the configuration file is file.conf. 


== File names

Names of input and output files are specified as follows. 

  &file
    inncfn  = "input.nc",  ! Input file
    outncfn = "output.nc"  ! Output file
  /

If several lines are written in a configuration file, only the first 
line is read. 


== Time index (optional)

If you need not convert all data in an input netcdf file, time index 
interval can be specified as follows. 

  &time
    ts =       1  ! start index
    te = 1000000  ! end index
  /

If you convert all of data, very large number can be specified to te. 


= end EN
