program spread

  use vtype_module
  use fi_module
  use ni3_module
!!$  use interpolate

  implicit none

  character(extstr)     :: ctlfn
  integer               :: ctlfu
  character(extstr)     :: mode
  integer               :: ios

  integer               :: inncid
  integer               :: outncid

  integer                        :: NDimsAll, NVarsAll, NAttsAll
  character(extstr), allocatable :: a_DimNamesAll(:)
  integer          , allocatable :: a_DimLenAll(:)
  integer          , allocatable :: a_XTypeAll(:)

  integer                        :: imaxOrg
  integer                        :: jmaxOrg
  integer                        :: kmaxOrg
!!$  integer                        :: tmaxOrg

  integer                        :: imax
  integer                        :: jmax
  integer                        :: kmax
  integer                        :: tmax

  integer                        :: dimlen
  integer            :: ndims
  integer            :: ndims_exc_time
  integer            :: xtype

  character(extstr)  :: dimname
  character(extstr)  :: VarName
  character(extstr)  :: VLevName
  real(DP)           :: VLevOffset
  real(DP)           :: VLevFactor
  character(extstr)  :: inncfn
  character(extstr)  :: outncfn
  character(extstr)  :: ncfn

  character(extstr), allocatable :: a_DimNames(:)
  integer          , allocatable :: a_DimLen(:)

  real(DP)         , allocatable :: x_LonOrg(:)
  real(DP)         , allocatable :: y_LatOrg(:)
  real(DP)         , allocatable :: a_LevOrg(:)

  real(DP)         , allocatable :: x_Lon(:)
  real(DP)         , allocatable :: y_Lat(:)
  real(DP)         , allocatable :: a_Lev(:)

  integer , allocatable :: a_iDim(:)
  real(sp), allocatable :: a_fDim(:)
  real(dp), allocatable :: a_dDim(:)

  integer               :: iVar
  integer , allocatable :: xy_iVarOrg (:,:)
  integer , allocatable :: xyz_iVarOrg(:,:,:)
  real(SP), allocatable :: xy_fVarOrg (:,:)
  real(SP), allocatable :: xyz_fVarOrg(:,:,:)
  real(DP), allocatable :: xy_dVarOrg (:,:)
  real(DP), allocatable :: xyz_dVarOrg(:,:,:)
  integer , allocatable :: xy_iVar (:,:)
  integer , allocatable :: xyz_iVar(:,:,:)
  real(SP), allocatable :: xy_fVar (:,:)
  real(SP), allocatable :: xyz_fVar(:,:,:)
  real(DP), allocatable :: xy_dVar (:,:)
  real(DP), allocatable :: xyz_dVar(:,:,:)


  logical            :: flag_inc_time_dim
  logical            :: flag_dim
  logical            :: flag_rst
  logical            :: flag_output
  logical            :: flag_positive

  integer            :: varid
  integer            :: dimid

  integer            :: i, j
  integer            :: l
  integer            :: t

  integer            :: ts
  integer            :: te
  integer            :: tstart
  integer            :: tend

!!$  integer, parameter :: MaxNmlArray = 256
!!$  character(stdstr)  :: PositiveVar(MaxNmlArray)
!!$  integer            :: NPositiveVar


  namelist /file/ inncfn, outncfn
  namelist /vlev/ VLevName, VLevOffset, VLevFactor
  namelist /time/ ts, te


  inncfn   = '-----'
  outncfn  = '-----'
  VLevName = '-----'
  VLevOffset = 0.0d0
  VLevFactor = 1.0d0

!!$  PositiveVar(:) = '###'

  imax     = -1

  ts       = -1
  te       = 2147483647

  ctlfn = 'mkncforparaview.conf'
  mode  = 'read'
  call fi_open( ctlfn, mode, ctlfu )
  rewind( ctlfu )
  read( ctlfu, nml = file, iostat = ios )
  if ( ios /= 0 ) stop 'Unable to read namelist file.'
  write( 6, file )
  rewind( ctlfu )
  read( ctlfu, nml = time, iostat = ios )
!!$  if ( ios /= 0 ) stop 'Unable to read namelist file.'
  write( 6, time )
  rewind( ctlfu )
  read( ctlfu, nml = vlev, iostat = ios )
!!$  if ( ios /= 0 ) stop 'Unable to read namelist file.'
  write( 6, vlev )
  close( ctlfu )

  if ( inncfn  == '-----' ) stop 'inncfn has to be given.'
  if ( outncfn == '-----' ) stop 'outncfn has to be given.'

!!$  NPositiveVar = 0
!!$  count_positive_variable : do l = 1, MaxNmlArray
!!$    if ( PositiveVar(l) == '###' ) exit count_positive_variable
!!$    NPositiveVar = NPositiveVar + 1
!!$  end do count_positive_variable


  ncfn = inncfn
  mode = "read"
  call ni3_open( ncfn, mode, inncid )

  mode = 'new'
  call ni3_open( outncfn, mode, outncid )


  call ni3_inq( inncid, NDimsAll, NVarsAll, NAttsAll )
  allocate( a_DimNamesAll( NDimsAll ) )
  call ni3_inq_dimnames( inncid, NDimsAll, a_DimNamesAll )

  allocate( a_XTypeAll ( NDimsAll ) )
  allocate( a_DimLenAll( NDimsAll ) )

  ! Check length of dimensions
  !
  do l = 1, NDimsAll
    call ni3_inq_var( inncid, a_DimNamesAll(l), xtype = a_XTypeAll(l) )
    call ni3_inq_dimlen( inncid, a_DimNamesAll(l), a_DimLenAll(l) )
  end do

  imaxOrg = -1
  do l = 1, NDimsAll
    if ( a_DimNamesAll(l) == 'lon' ) imaxOrg = a_DimLenAll(l)
  end do
  if ( imaxOrg == -1 ) stop 'longitude cannot be found'
  imax = imaxOrg
  !
  jmaxOrg = -1
  do l = 1, NDimsAll
    if ( a_DimNamesAll(l) == 'lat' ) jmaxOrg = a_DimLenAll(l)
  end do
  if ( jmaxOrg == -1 ) stop 'latitude cannot be found'
  !
  tmax = -1
  do l = 1, NDimsAll
    if ( a_DimNamesAll(l) == 'time' ) tmax = a_DimLenAll(l)
  end do
  if ( tmax == -1 ) stop 'time cannot be found'
  !
  ts = min( max( ts, 1 ), tmax )
  te = min( max( te, 1 ), tmax )


  ! Set horizontal resolution
  jmax = imax / 2

!!$  write( 6, * ) 'Original number of grids:'
!!$  write( 6, * ) '  imax : ', imaxOrg
!!$  write( 6, * ) '  jmax : ', jmaxOrg !, kmaxOrg
!!$  write( 6, * ) 'Converged number of grids:'
!!$  write( 6, * ) '  imax : ', imax
!!$  write( 6, * ) '  jmax : ', jmax    !, kmaxOrg
  write( 6, * ) 'Converged number of time levels:'
  write( 6, * ) '  ts   : ', ts
  write( 6, * ) '  te   : ', te
  write( 6, * ) '  NOTE : Time levels included in input file is ', tmax, '.'


  ! Set original grids
  allocate( x_LonOrg( imaxOrg ) )
  allocate( y_LatOrg( jmaxOrg ) )
  do l = 1, NDimsAll
    dimname = a_DimNamesAll(l)
    if ( dimname == 'lon' ) then
      call ni3_get_var( inncid, dimname, x_LonOrg )
    else if ( dimname == 'lat' ) then
      call ni3_get_var( inncid, dimname, y_LatOrg )
    end if
  end do



  ! Set converged grids
  allocate( x_Lon( imax ) )
  allocate( y_Lat( jmax ) )
  x_Lon = x_LonOrg
!!$  do i = 1, imax
!!$    x_Lon( i ) = i
!!$  end do
  y_Lat = y_LatOrg
!!$  do j = 1, jmax
!!$    y_Lat( j ) = j
!!$  end do


  ! Treatment of vertical coordinate
  !
  kmaxOrg = -1
  do l = 1, NDimsAll
    if ( a_DimNamesAll(l) == VLevName ) kmaxOrg = a_DimLenAll(l)
  end do
  if ( kmaxOrg == -1 ) then
    write( 6, * ) trim(VLevName) // ' cannot be found.'
    write( 6, * ) 'Vertical coordinate is not scaled.'
!!$    stop
  end if
  !
  if ( kmaxOrg /= -1 ) then
    allocate( a_LevOrg( kmaxOrg ) )
    do l = 1, NDimsAll
      dimname = a_DimNamesAll(l)
      if ( dimname == VLevName ) then
        call ni3_get_var( inncid, dimname, a_LevOrg )
      end if
    end do
  end if
  !
  if ( kmaxOrg /= -1 ) then
    kmax = kmaxOrg
    allocate( a_Lev( kmax ) )
    a_Lev = VLevOffset + VLevFactor * a_LevOrg
  end if


  ! Output global attributes
  !

  call ni3_cp_atts( inncid, outncid, 'global' )


  ! Output dimensions
  !

  do l = 1, NDimsAll
    dimlen  = a_DimLenAll(l)
    dimname = a_DimNamesAll(l)
    xtype   = a_XTypeAll(l)

    if ( dimname == 'lon' ) then
      call ni3_set_dim( outncid, dimname, xtype, x_Lon )
!!$      call ni3_def_dim( outncid, dimname, xtype, imax, flag_var = .false. )
    else if ( dimname == 'lat' ) then
      call ni3_set_dim( outncid, dimname, xtype, y_Lat )
!!$      call ni3_def_dim( outncid, dimname, xtype, jmax, flag_var = .false. )
    else if ( dimname == VLevName ) then
      call ni3_set_dim( outncid, dimname, xtype, a_Lev )
!!$      call ni3_def_dim( outncid, dimname, xtype, kmax, flag_var = .false. )
    else

      select case ( xtype )
      case ( NI3_INT )
        allocate( a_iDim( dimlen ) )
        call ni3_get_var( inncid, dimname, a_iDim )
        if ( dimname == 'time' ) then
          call ni3_def_dim( outncid, dimname, xtype, 0 )
          tstart = ts
          tend   = te
          do t = tstart, tend
            call ni3_put_varss( outncid, dimname, t-tstart+1, a_iDim( t ) )
!!$          do t = 1, dimlen
!!$            call ni3_put_varss( outncid, dimname, t, a_iDim( t ) )
          end do
        else
          call ni3_set_dim( outncid, dimname, xtype, a_iDim )
        end if
        deallocate( a_iDim )
      case ( NI3_REAL )
        allocate( a_fDim( dimlen ) )
        call ni3_get_var( inncid, dimname, a_fDim )
        if ( dimname == 'time' ) then
          call ni3_def_dim( outncid, dimname, xtype, 0 )
          tstart = ts
          tend   = te
          do t = tstart, tend
            call ni3_put_varss( outncid, dimname, t-tstart+1, a_fDim( t ) )
!!$          do t = 1, dimlen
!!$            call ni3_put_varss( outncid, dimname, t, a_fDim( t ) )
          end do
        else
          call ni3_set_dim( outncid, dimname, xtype, a_fDim )
        end if
        deallocate( a_fDim )
      case ( NI3_DOUBLE )
        allocate( a_dDim( dimlen ) )
        call ni3_get_var( inncid, dimname, a_dDim )
        if ( dimname == 'time' ) then
          call ni3_def_dim( outncid, dimname, xtype, 0 )
          tstart = ts
          tend   = te
          do t = tstart, tend
            call ni3_put_varss( outncid, dimname, t-tstart+1, a_dDim( t ) )
!!$          do t = 1, dimlen
!!$            call ni3_put_varss( outncid, dimname, t, a_dDim( t ) )
          end do
        else
          call ni3_set_dim( outncid, dimname, xtype, a_dDim )
        end if
        deallocate( a_dDim )
      end select

      call ni3_cp_atts( inncid, outncid, dimname )
      if ( dimname == 'time' ) then
        call ni3_put_att( outncid, dimname, 'units', 'day' )
      end if


    end if

  end do



  ! Inquire variable
  !

  loop_variables : do varid = 1, NVarsAll

    call ni3_inq_varname( inncid, varid, VarName )
    write( 6, * ) varid, ':', trim( VarName )

    flag_dim = .false.
    do dimid = 1, NDimsAll
      dimname = a_DimNamesAll(dimid)
      if ( dimname == VarName ) then
        flag_dim = .true.
      end if
    end do

    flag_output = .true.
    flag_rst    = .false.

    if ( flag_dim ) then

      flag_output = .false.

    else

      call ni3_inq_var( inncid, VarName, ndims = ndims, xtype = xtype )

      if ( ndims >= 2 ) then

        allocate( a_DimNames( ndims ) )
        call ni3_inq_vardimnames( inncid, VarName, ndims, a_DimNames )
        allocate( a_DimLen( ndims ) )
        do l = 1, ndims
          call ni3_inq_dimlen( inncid, a_DimNames(l), a_DimLen(l) )
        end do

        ! check dimensions
        !
        if ( a_DimNames(1) /= 'lon' ) then
          write( 6, * ) '      1st dimension is not lon, but ', trim( a_DimNames(1) )
          flag_output = .false.
        end if
        if ( a_DimNames(2) /= 'lat' ) then
          write( 6, * ) '      2nd dimension is not lat, but ', trim( a_DimNames(1) )
          flag_output = .false.
        end if
        if ( a_DimNames(ndims) == 'time' ) then
          flag_inc_time_dim = .true.
!!$          tmax              = a_DimLen(ndims)
        else
          flag_inc_time_dim = .false.
!!$          tmax              = 1
        end if
        if ( flag_inc_time_dim ) then
          ndims_exc_time = ndims - 1
        else
          ndims_exc_time = ndims
        end if

        if ( .not. flag_output ) then
          deallocate( a_DimNames )
          deallocate( a_DimLen   )
        end if

      else

        if ( VarName == 'flag_rst' ) then
          flag_rst = .true.
        end if

        flag_output = .false.
      end if

    end if

    flag_positive = .false.
!!$    do l = 1, NPositiveVar
!!$      if ( VarName == PositiveVar(l) ) flag_positive = .true.
!!$    end do

    if ( flag_output ) then

      ! define variable
      !
      call ni3_def_var( outncid, VarName, xtype, ndims, a_DimNames )
      call ni3_cp_atts( inncid, outncid, VarName )


      select case ( xtype )
      case ( NI3_INT )
        select case ( ndims_exc_time )
        case ( 2 )
          allocate( xy_iVarOrg ( a_DimLen(1), a_DimLen(2) ) )
        case ( 3 )
          allocate( xyz_iVarOrg( a_DimLen(1), a_DimLen(2), a_DimLen(3) ) )
        end select
      case ( NI3_REAL )
        select case ( ndims_exc_time )
        case ( 2 )
          allocate( xy_fVarOrg ( a_DimLen(1), a_DimLen(2) ) )
        case ( 3 )
          allocate( xyz_fVarOrg( a_DimLen(1), a_DimLen(2), a_DimLen(3) ) )
        end select
      case ( NI3_DOUBLE )
        select case ( ndims_exc_time )
        case ( 2 )
          allocate( xy_dVarOrg ( a_DimLen(1), a_DimLen(2) ) )
        case ( 3 )
          allocate( xyz_dVarOrg( a_DimLen(1), a_DimLen(2), a_DimLen(3) ) )
        end select
      end select


      if ( flag_inc_time_dim ) then
        tstart = ts
        tend   = te
      else
        tstart = 1
        tend   = 1
      end if
      loop_time : do t = tstart, tend
!!$      loop_time : do t = 1, tmax

        ! get
        select case ( xtype )
        case ( NI3_INT )
          select case ( ndims_exc_time )
          case ( 2 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xy_iVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xy_iVarOrg )
            end if
          case ( 3 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xyz_iVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xyz_iVarOrg )
            end if
          end select
        case ( NI3_REAL )
          select case ( ndims_exc_time )
          case ( 2 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xy_fVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xy_fVarOrg )
            end if
          case ( 3 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xyz_fVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xyz_fVarOrg )
            end if
          end select
        case ( NI3_DOUBLE )
          select case ( ndims_exc_time )
          case ( 2 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xy_dVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xy_dVarOrg )
            end if
          case ( 3 )
            if ( flag_inc_time_dim ) then
              call ni3_get_varss( inncid, VarName, t, xyz_dVarOrg )
            else
              call ni3_get_var  ( inncid, VarName, xyz_dVarOrg )
            end if
          end select
        end select


        ! put
        select case ( xtype )
        case ( NI3_INT )
          select case ( ndims_exc_time )
          case ( 2 )
            allocate( xy_iVar( imax, jmax ) )
            write( 6, * ) 'Not supported: ', VarName
            stop
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg,   &
!!$              & x_LonOrg, y_LatOrg, &
!!$              & xy_iVarOrg,         &
!!$              & imax,    jmax,      &
!!$              & x_Lon,    y_Lat,    &
!!$              & xy_iVar             &
!!$              & )
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xy_iVar = max( xy_iVar, 0 )
            end if
            if ( flag_inc_time_dim ) then
!!$              call ni3_put_varss( outncid, VarName, t, xy_iVar )
              call ni3_put_varss( outncid, VarName, t-tstart+1, xy_iVar )
            else
              call ni3_put_var  ( outncid, VarName, xy_iVar )
            end if
            deallocate( xy_iVar )
          case ( 3 )
            allocate( xyz_iVar( imax, jmax, a_DimLen(3) ) )
            write( 6, * ) 'Not supported: ', VarName
            stop
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg, kmaxOrg,     &
!!$              & x_LonOrg, y_LatOrg, z_SigOrg,  &
!!$              & xyz_iVarOrg,                   &
!!$              & imax,    jmax,    kmax,        &
!!$              & x_Lon,    y_Lat,    z_Sig,     &
!!$              & xyz_iVar                       &
!!$              & )
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xyz_iVar = max( xyz_iVar, 0 )
            end if
            if ( flag_inc_time_dim ) then
              call ni3_put_varss( outncid, VarName, t-tstart+1, xyz_iVar )
            else
              call ni3_put_var  ( outncid, VarName, xyz_iVar )
            end if
            deallocate( xyz_iVar )
          end select
        case ( NI3_REAL )
          select case ( ndims_exc_time )
          case ( 2 )
            allocate( xy_fVar( imax, jmax ) )
!!$            write( 6, * ) 'Not supported: ', VarName
!!$            stop
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg,   &
!!$              & x_LonOrg, y_LatOrg, &
!!$              & xy_fVarOrg,         &
!!$              & imax,    jmax,      &
!!$              & x_Lon,    y_Lat,    &
!!$              & xy_fVar             &
!!$              & )
            xy_fVar = xy_fVarOrg
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xy_fVar = max( xy_fVar, 0.0d0 )
            end if
            if ( flag_inc_time_dim ) then
              call ni3_put_varss( outncid, VarName, t-tstart+1, xy_fVar )
            else
              call ni3_put_var  ( outncid, VarName, xy_fVar )
            end if
            deallocate( xy_fVar )
          case ( 3 )
            allocate( xyz_fVar( imax, jmax, a_DimLen(3) ) )
!!$            write( 6, * ) 'Not supported: ', VarName
!!$            stop
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg, a_DimLen(3), &
!!$              & x_LonOrg, y_LatOrg, & !z_SigOrg,  &
!!$              & xyz_fVarOrg,                   &
!!$              & imax,    jmax,    a_DimLen(3), &
!!$              & x_Lon,    y_Lat,    & !z_Sig,     &
!!$              & xyz_fVar                       &
!!$              & )
            xyz_fVar = xyz_fVarOrg
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg, kmaxOrg,     &
!!$              & x_LonOrg, y_LatOrg, z_SigOrg,  &
!!$              & xyz_fVarOrg,                   &
!!$              & imax,    jmax,    kmax,        &
!!$              & x_Lon,    y_Lat,    z_Sig,     &
!!$              & xyz_fVar                       &
!!$              & )
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xyz_fVar = max( xyz_fVar, 0.0d0 )
            end if
            if ( flag_inc_time_dim ) then
              call ni3_put_varss( outncid, VarName, t-tstart+1, xyz_fVar )
            else
              call ni3_put_var  ( outncid, VarName, xyz_fVar )
            end if
            deallocate( xyz_fVar )
          end select
        case ( NI3_DOUBLE )
          select case ( ndims_exc_time )
          case ( 2 )
            allocate( xy_dVar( imax, jmax ) )
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg,   &
!!$              & x_LonOrg, y_LatOrg, &
!!$              & xy_dVarOrg,         &
!!$              & imax,    jmax,      &
!!$              & x_Lon,    y_Lat,    &
!!$              & xy_dVar             &
!!$              & )
            xy_dVar = xy_dVarOrg
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xy_dVar = max( xy_dVar, 0.0d0 )
            end if
            if ( flag_inc_time_dim ) then
              call ni3_put_varss( outncid, VarName, t-tstart+1, xy_dVar )
            else
              call ni3_put_var  ( outncid, VarName, xy_dVar )
            end if
            deallocate( xy_dVar )
          case ( 3 )
            allocate( xyz_dVar( imax, jmax, a_DimLen(3) ) )
!!$            call InterpolateHorVar( &
!!$              & imaxOrg, jmaxOrg, a_DimLen(3), &
!!$              & x_LonOrg, y_LatOrg, & !z_SigOrg,  &
!!$              & xyz_dVarOrg,                   &
!!$              & imax,    jmax,    a_DimLen(3), &
!!$              & x_Lon,    y_Lat,    & !z_Sig,     &
!!$              & xyz_dVar                       &
!!$              & )
            xyz_dVar = xyz_dVarOrg
            if ( flag_positive ) then
              write( 6, * ) '              Positive definite'
              xyz_dVar = max( xyz_dVar, 0.0d0 )
            end if
            if ( flag_inc_time_dim ) then
              call ni3_put_varss( outncid, VarName, t-tstart+1, xyz_dVar )
            else
              call ni3_put_var  ( outncid, VarName, xyz_dVar )
            end if
            deallocate( xyz_dVar )
          end select
        end select


      end do loop_time


      select case ( xtype )
      case ( NI3_INT )
        select case ( ndims_exc_time )
        case ( 2 )
          deallocate( xy_iVarOrg )
        case ( 3 )
          deallocate( xyz_iVarOrg )
        end select
      case ( NI3_REAL )
        select case ( ndims_exc_time )
        case ( 2 )
          deallocate( xy_fVarOrg )
        case ( 3 )
          deallocate( xyz_fVarOrg )
        end select
      case ( NI3_DOUBLE )
        select case ( ndims_exc_time )
        case ( 2 )
          deallocate( xy_dVarOrg )
        case ( 3 )
          deallocate( xyz_dVarOrg )
        end select
      end select

      deallocate( a_DimNames )
      deallocate( a_DimLen   )

    else
      if ( ( .not. flag_dim ) .and. ( .not. flag_rst ) ) then
        write( 6, * ) '              Skip'
      end if
    end if

    if ( flag_rst ) then
      allocate( a_DimNames(0) )
      call ni3_def_var( outncid, VarName, xtype, ndims, a_DimNames )
      call ni3_cp_atts( inncid, outncid, VarName )
      call ni3_get_var( inncid , VarName, iVar )
      call ni3_put_var( outncid, VarName, iVar )
      deallocate( a_DimNames )
    end if


  end do loop_variables


  deallocate( x_Lon )
  deallocate( y_Lat )
  if ( kmaxOrg /= -1 ) then
    deallocate( a_Lev )
  end if
  deallocate( x_LonOrg )
  deallocate( y_LatOrg )
  deallocate( a_LevOrg )

  call ni3_close( outncid )

  call ni3_close( inncid  )


end program spread

