#
# Usage:
# $ ruby mkncforparaview.rb <variable name> <input .nc file> <output .nc file>
# Example:
# $ ruby mkncforparaview.rb U in.nc out.nc
#

require "numru/gphys"
include NumRu

vname = ARGV[0]
inncfn = ARGV[1]
outncfn = ARGV[2]

if inncfn == outncfn  then
  print "Input and output files are the same.\n"
  exit
end

gp = GPhys::IO.open inncfn, vname

gpout = gp.copy

namelev = 'lon'
z = gpout.axis(namelev).pos
z.units = '1'
gpout.axis(namelev).set_pos(z)

namelev = 'lat'
z = gpout.axis(namelev).pos
z.units = '1'
gpout.axis(namelev).set_pos(z)

sig = gpout.coord('sig').val
sig = ( 1.0 - sig ) * 100.0
varraytime = VArray.new( sig,
                         { "units"=>'1' }, "sig" )
gpout.axis('sig').set_pos(varraytime)

namelev = 'time'
z = gpout.axis(namelev).pos
if z.units != 'day' || z.units != 'day' then
  print "Unit of time is changed to day.\n"
  z.units = 'day'
  gpout.axis(namelev).set_pos(z)
end


ofile = NetCDF.create outncfn
GPhys::IO.write ofile, gpout
ofile.close
