=begin JA
= RDWebgen - RD から html を生成するスクリプト

== これは何?

RD ファイルから今風の Web ページを生成するための ((:<span>Rakefile</span>:)) と YAML の設定ファイルです.

似た様なソフトウェアとしては
* ((<"Jekyll • Simple, blog-aware, static sites"|URL:http://jekyllrb.com/>))
* ((<"Home | webgen - static website generator"|URL:http://webgen.gettalong.org/>)) 
なんかがあります. 先ずはこれらソフトウェアの使用をお考え下さい. 

本スクリプトは, 
これらソフトウェアが((<"電脳サーバ"|URL:http://dennou-k.gfd-dennou.org>))での運用方針に合わない, 
という理由から作成されました. 

具体的には

* ソースとして RD ファイルを使いたい.
* ソースの置き場所と公開ディレクトリは((*同じ*))でなければならない
* 用意するファイルはできる限り少ない方が良い
  * 今迄 Makefile 一発でやっていたので, それぐらいでなんとか...

です. 

解決策として

* 単一の Rakefile に全ての処理を記載する

という非常に愚かな事をしています(そのうち機能分離するかもしれませんが, 現状はそうなっています).

== 使い方

* tar.gz を展開します. 中身は以下の通りです.  
* ((:assets:)) ディレクトリ Web から見える場所に置きます.
  ((:assets:)) ディレクトリには生成された HTML ファイルで必ず使用する CSS と Javascript が含まれています.
* ((:Rakefile:)) を適当な場所に置きます. このファイル自体が Web で見える必要はありません.
* RD ファイルを置いた場所に上記 Rakefile への symbolic link を作成します.
* ((:config.yml.template:)) を ((:config.yml:)) へ rename し, RD ファイルを置いた場所にコピーします.
* ((:config.yml:)) を見て, 必要な情報を修正します.
* rake を実行します.


=end JA
