    subroutine mksfcindex( im, jm, lon, lat, midlon, midlat, sfcindex )

      use vtype_module
      use const_module
      use ni3_module

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: lon( im ), lat( jm )
      real(dp)    , intent(in ) :: midlon( im+1 ) , midlat( jm+1 )
      integer(i4b), intent(out) :: sfcindex( im, jm )


      !
      ! local variables
      !
      integer(i4b)              :: nx, ny
      real(dp)    , allocatable :: matlon( : ), matlat( : )
      real(dp)    , allocatable :: matlon_bnds( :, : ), matlat_bnds( :, : )
      integer(i4b), allocatable :: matveg( :, : )
      integer(i4b)              :: nvegtypes, nvegtypee
      real(dp)    , allocatable :: hist_vegtype( : )
      integer(i4b)              :: i_max_hist
      real(dp)                  :: max_hist
      real(dp)                  :: mindis
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid
      integer(i4b)              :: i , j , l
      integer(i4b)              :: ii, jj
      logical                   :: flag_grid


      path = '../matthews_2008-12-21/matthews_vegtype_culint.nc'
      mode = 'read'
      call ni3_open( path, mode, ncid )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )
      allocate( &
           matlon( nx ), matlat( ny ), &
           matlon_bnds( 2, nx ), matlat_bnds( 2, ny ), &
           matveg( nx, ny ) )
      call ni3_get_var( ncid, 'lon'     , matlon      )
      call ni3_get_var( ncid, 'lat'     , matlat      )
      call ni3_get_var( ncid, 'lon_bnds', matlon_bnds )
      call ni3_get_var( ncid, 'lat_bnds', matlat_bnds )
      call ni3_get_var( ncid, 'vegtype' , matveg      )
      call ni3_close( ncid )


      do j = 1, ny
         do i = 1, nx
            if( matveg( i, j ) .lt. 0 ) matveg( i, j ) = 0
         end do
      end do


      if( ( im .ge. nx ) .or. ( jm .ge. ny ) ) then

         write( 6, * ) 'High resolution version'

         do j = 1, jm
            do i = 1, im

               call nearest( nx, ny, matlon, matlat, lat( j ), lon( i ), &
                    ii, jj, mindis )
               sfcindex( i, j ) = matveg( ii, jj )

            end do
         end do

      else

         write( 6, * ) 'Low resolution version'

         nvegtypes = 10000
         nvegtypee =     0
         do j = 1, ny
            do i = 1, nx
               if( matveg( i, j ) .lt. nvegtypes ) nvegtypes = matveg( i, j )
               if( matveg( i, j ) .gt. nvegtypee ) nvegtypee = matveg( i, j )
            end do
         end do

         allocate( hist_vegtype( nvegtypes:nvegtypee ) )

         do j = 1, jm
            do i = 1, im

               do l = nvegtypes, nvegtypee
                  hist_vegtype( l ) = 0.0d0
               end do
               do jj = 1, ny
                  do ii = 1, nx
                     if(  ( matlon( ii ) .ge. midlon( i   ) ) .and. &
                          ( matlon( ii ) .lt. midlon( i+1 ) ) .and. &
                          ( matlat( jj ) .ge. midlat( j   ) ) .and. &
                          ( matlat( jj ) .lt. midlat( j+1 ) ) ) then
                        hist_vegtype( matveg( ii, jj ) ) &
                             = hist_vegtype( matveg( ii, jj ) ) &
                             + ( matlon_bnds( 2, ii ) - matlon_bnds( 1, ii ) ) * d2r &
                             * cos( matlat( jj ) * d2r ) &
                             * ( matlat_bnds( 2, jj ) - matlat_bnds( 1, jj ) ) * d2r
                     end if
                  end do
               end do
               flag_grid = .false.
               do l = nvegtypes, nvegtypee
                  if( hist_vegtype( l ) .gt. 0.0d0 ) flag_grid = .true.
               end do
               if( .not. flag_grid ) then
                  stop 'There is no grid in Matthews database in the model grid.'
               end if
               i_max_hist = nvegtypes
               max_hist   = 0.0d0
               do l = nvegtypes, nvegtypee
                  if( hist_vegtype( l ) .gt. max_hist ) then
                     max_hist   = hist_vegtype( l )
                     i_max_hist = l
                  end if
               end do
               sfcindex( i, j ) = i_max_hist

            end do
         end do

         deallocate( hist_vegtype )

      end if


      deallocate( matveg )


    end subroutine mksfcindex
