=begin JA

= Polvani et al. (2004) の傾圧不安定波動実験

# * 高橋 芳幸 (yot), 竹広 真一(takepiro)
#   * $Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $

=end JA
=begin EN

= Baroclinic wave experiment by Polvani et al. (2004)

# * Yoshiyuki O. Takahashi (yot), Shin-ichi Takehiro (takepiro)
#   * $Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $

=end EN


=begin JA
Polvani et al. (2004) で行われた, 傾圧不安定波動の実験を実行する方法を説明します. 
=end JA
=begin EN
A method to perform a baroclinic wave experiment by Polvani et al. (2004) is described. 
=end EN


=begin JA
== 概要
本実験は海表面温度等の実験用データを用いないため, 以下の 3 つのステップで行います.

  * 実験ディレクトリの準備
  * 初期値の準備
  * 実験の実行
=end JA
=begin EN
== Overview
This experiment does not require additional data, such as SST data. 
Thus, the experiment is performed with the following 3 steps:

  * Preparation of directory for experiments
  * Preparation of initial condition
  * Execution of experiments
=end EN


=begin JA

== 実験用ディレクトリ準備

DCPAM5 の数値実験はソースツリー内部では行わず
ソースツリーとは別の外部ディレクトリにて行うことを推奨いたします. 

まず DCPAM5 ソースのトップディレクトリ(以下の例では dcpam5-YYYYMMDD とする)に移動してください. 
以下では DCPAM5 ソースディレクトリの隣に ../dcpma5-exp/p04-exp ディレクトリを作成し, そこで実験を行うことにします. 
次のように  ../dcpam5-exp/p04-exp ディレクトリを作成し, 
移動してください. 

  $ mkdir -p ../dcpam5-exp/p04-exp
  $ cd ../dcpam5-exp/p04-exp

次に, このディレクトリに実行ファイルと設定ファイル置き場を作成します. 

  $ mkdir bin
  $ mkdir conf

最後に作成したディレクトリに実行ファイルと設定ファイルをコピーします. 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

なお, 実行ファイルと設定ファイル (NAMELIST ファイル) があれば, どのディレクトリにおいても計算を行うことができます. 


=end JA
=begin EN

== Preparation of a directory for experiments

Let us move to the top directory of DCPAM5 src tree
(assuming dcpam5-YYYYMMDD in the following example). 
Here, we perform an experiment in ../dcpam5-exp/p04-exp directory. 
Please create the directory and enter there as follows: 

  $ mkdir -p ../dcpam5-exp/p04-exp
  $ cd ../dcpam5-exp/p04-exp

Then, pleaase create the directories for executable files and configuration
files as follows:

  $ mkdir bin
  $ mkdir conf

Finally, executable files and configuration files are copied as follows: 

  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_main bin
  $ cp ../../dcpam5-YYYYMMDD/src/main/dcpam_init_data  bin
  $ cp ../../dcpam5-YYYYMMDD/exp_setup_files/*.conf conf

Note that you can perform an experiment in any directory by using executable files and configuration (NAMELIST) files.

=end EN


=begin JA

== 初期値データファイルの作成

dcpam_init_data と init_data_p04_T21L20.conf
を用いて初期値ファイル init_T21L20.nc を作成します. 

  $ ./bin/dcpam_init_data -N=./conf/init_data_p04_T21L20.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/init_data_p04_T21L20.conf".
                         : 
   *** MESSAGE [initial_data] ***    QVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L20.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.200000E-01
   ------------------------------------------------
          TOTAL TIME =    0.200000E-01


== 実験の実行

実行ファイル "dcpam_main" と NAMELIST ファイル
((<dcpam_p04_T21L20.conf|URL:../../exp_setup_files/dcpam_p04_T21L20.conf>))
を用いて, 以下のように dcpam_main を実行してください. 
プログラム終了には数分〜数十分かかります. 

(なお, クロスコンパイル環境では以下の方法でプログラムを
実行することはできないので注意してください. その場合の実行方法
に関しては, その環境でのプログラム実行マニュアルなどを参照ください. )

  $ ./bin/dcpam_main -N=./conf/dcpam_p04_T21L20.conf | tee p04.log

   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [dcpam_main] ***  NAMELIST group "dcpam_main_nml" is loaded from "./conf/dcpam_p04_T21L20.conf".
   &DCPAM_MAIN_NML FLAGDYNAMICS=T,FLAGFULLPHYSICS=F,FLAGHS94=F,FLAGVENUSSIMPLE=F,FLAGJUPITERSIMPLE=F,FLAGRADIATIONDENNOUAGCM=T,FLAGRADIATIONDCPAMEV1=F,FLAGRADIATIONDCPAMMV1=F,FLAGRADIATIONSL09=F,FLAGPHYIMP1LAYMODEL=T,FLAGPHYIMPSOILMODEL=F,FLAGPHYIMPSOILMODELSO=F,FLAGPHYIMPATMONLY=F,FLAGVERTICALFILTER=F/
   *** MESSAGE [dcpam_main] ***  FlagDynamics=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDennouAGCM=<T>.
                     :
   *** MESSAGE [HistoryClose] ***  "TotEngy.nc" is closed
   *** MESSAGE [HistoryClose] ***  "Enstro.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   surface_properties     0.904434E-07
   dynamics_hspl_vas83    0.380824E+01
   mass_fixer             0.132011E+00
   check_prog_vars        0.360025E-01
   timefilter_asselin19   0.760067E-01
   others                 0.212009E+00
   ------------------------------------------------
          TOTAL TIME =    0.426427E+01

この場合, 12 日分の時間積分が行われます. 
空間解像度は T21L20 (経度格子点数 64, 緯度点数 32, 鉛直層数 20) です. 
計算結果は U.nc や Temp.nc として出力されます. 
また, リスタートファイルが rst.nc として出力されます. 

=end JA

=begin EN

== Create initial data file

Create initial data file "init_T21L20.nc"
using "bin/dcpam_init_data" and "conf/init_data_p04_T21L20.conf" 
  
  $ ./bin/dcpam_init_data -N=./conf/init_data_p04_T21L20.conf

   *** MESSAGE [init_data] ***  Run: Initial data generation
   *** MESSAGE [init_data] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [timeset] ***  NAMELIST group "timeset_nml" is loaded from "./conf/init_data_p04_T21L20.conf".
                         : 
   *** MESSAGE [initial_data] ***    QVapAvr = 0.
   *** MESSAGE [initial_data] ***    Ueq     = 0.
   *** MESSAGE [initial_data] ***
   *** MESSAGE [initial_data] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [HistoryClose] ***  "init_T21L20.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   others                 0.200000E-01
   ------------------------------------------------
          TOTAL TIME =    0.200000E-01


== Run the experiment

Using an executable files 'dcpam_main' and a NAMELIST file
((<dcpam_p04_T21L20.conf|URL:../../exp_setup_files/dcpam_p04_T21L20.conf>)), 
execute 'dcpam_main' as follows. 
This program will be finished in few minutes - tens of minutes. 

  $ ./bin/dcpam_main -N=./conf/dcpam_p04_T21L20.conf | tee p04.log

   *** MESSAGE [namelist_util] ***  ----- Initialization Messages -----
   *** MESSAGE [namelist_util] ***    MaxNmlArySize = 256
   *** MESSAGE [namelist_util] ***  -- version = $Name:  $$Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
   *** MESSAGE [dcpam_main] ***  NAMELIST group "dcpam_main_nml" is loaded from "./conf/dcpam_p04_T21L20.conf".
   &DCPAM_MAIN_NML FLAGDYNAMICS=T,FLAGFULLPHYSICS=F,FLAGHS94=F,FLAGVENUSSIMPLE=F,FLAGJUPITERSIMPLE=F,FLAGRADIATIONDENNOUAGCM=T,FLAGRADIATIONDCPAMEV1=F,FLAGRADIATIONDCPAMMV1=F,FLAGRADIATIONSL09=F,FLAGPHYIMP1LAYMODEL=T,FLAGPHYIMPSOILMODEL=F,FLAGPHYIMPSOILMODELSO=F,FLAGPHYIMPATMONLY=F,FLAGVERTICALFILTER=F/
   *** MESSAGE [dcpam_main] ***  FlagDynamics=<T>.
   *** MESSAGE [dcpam_main] ***  FlagRadiationDennouAGCM=<T>.
                     :
   *** MESSAGE [HistoryClose] ***  "TotEngy.nc" is closed
   *** MESSAGE [HistoryClose] ***  "Enstro.nc" is closed
  
   ############## CPU TIME SUMMARY ################
   surface_properties     0.904434E-07
   dynamics_hspl_vas83    0.380824E+01
   mass_fixer             0.132011E+00
   check_prog_vars        0.360025E-01
   timefilter_asselin19   0.760067E-01
   others                 0.212009E+00
   ------------------------------------------------
          TOTAL TIME =    0.426427E+01

In this case, 12 days integration is performed. 
Resolution is T21L20 (Number of grid points of longitude, latitude is 
64, 32, and number of vertical layer is 20). 
History data are output to 'U.nc' and 'Temp.nc' etc., 
and a restart data is output to 'restart.nc'. 

=end EN

=begin JA
== 結果の可視化
((<簡単な解析・可視化|URL:./visualization.htm>)) を参照してください. 
参考文献の図との比較の仕方がかかれています. 
=end JA
=begin EN
=end EN

=begin JA
== 最後に
実験ディレクトリに作成された計算結果を保存しておきたい場合には
データ用ディレクトリ(例えば data01)を作成し, 
ファイルを移動させて整理しておきましょう. 

  $ mkdir data01
  $ mv *.nc *.log data01/

なお, 計算結果を計算実行時にサブディレクトリへ出力することも可能です. 
((<実験設定の変更|URL:./changesetup.htm>))の出力設定の変更を参照し, 
NAMELIST "&gtool_historyauto_nml" の変数 "FilePrefix" による設定を試してみて下さい. 
=end JA

=begin EN
== Final remark
If you would like to keep the results of the numerical experiment, 
please create a sub directory ("data01" for example), move the files, 
and keep the current directory neatly. 

  $ mkdir data01
  $ mv *.nc *.log data01/

You can output the results of the numerical experimet concurrently with the
execution. Please refer to "Change output settings" 
in ((<Change experimental setup|URL:./changesetup.htm.en>)) 
and try to configure "FilePrefix" variable in NAMELIST "&gtool_historyauto_nml". 

=end EN

=begin JA
== 参考文献
=end JA

=begin EN
== References
=end EN

=begin
* ((<
  Polvani, L. M., R. K. Scott, S. J. Thomas, 2004: 
  Numerically Converged Solutions of the Global Primitive Equations for 
  Testing the Dynamical Core of Atmospheric GCMs. 
  Mon. Wea. Rev., 132, 2539 -- 2552. 
  |URL:http://journals.ametsoc.org/doi/abs/10.1175/MWR2788.1>))
=end


=begin HTML
<hr />
<small>
  $Id: exp-p04.rd,v 1.14 2014/07/07 14:50:00 yot Exp $
</small>
=end HTML

