require "numru/ggraph"
include NumRu

fns = 1
fne = 4
path = Array.new(fne-fns+1)
for i in fns..fne do
  path[i-fns] = i.to_s.rjust(4,'0') + "/U_rank000000.nc"
end
#path = path + ["U_rank000000.nc"]

#path = "????/U_rank000000.nc"
#path = /(\d\d\d\d)\/U_rank000000.nc/

vname = "U"

print "File: ", path, "\n"
gphys = GPhys::IO.open( path, vname )

gphys = gphys.mean('lon').mean('lat')
time = gphys.coord('time').val
ntime = time.size

nave = ntime / 4000 + 1
nave = 117
print "Running averaging with ", nave, " data\n"

ntimeshort = ntime/nave
print "  ntime: ", ntime, ", ntimeshort: ", ntimeshort, "\n"
gp = gphys.cut('time'=>time[0]..time[ntimeshort-1]).copy

time_out = gp.coord('time').val

for i in 0..(ntimeshort-1)
  gp[true,i] = gphys.cut('time'=>time[i*nave]..time[i*nave+nave-1]).mean('time')
  time_out[i] = time[(i*nave)..(i*nave+nave-1)].mean
#  p time[i*nave]
#  p time[i*nave+nave-1]
end
time_out = time_out / 117.0

#p time_out
va_time = VArray.new( time_out,
                         { "long_name"=>'time',
                           "units"=>'Venus days' }, "time" )
gp.axis('time').set_pos(va_time)


iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL.gropn(iws)

#DCL.sldiv('y',1,4)
DCL.sgpset('isub', 96)   # control character of subscription: '_' --> '`'
DCL.sgpset('lfull',true)
DCL.uzfact(0.6)
GGraph.set_fig 'itr'=> 2, 'viewport'=>[0.15,0.85,0.15,0.6]

GGraph.tone gp, true, 'exchange'=>true
GGraph.contour gp, false, 'exchange'=>true
GGraph.color_bar

GGraph.set_fig 'itr'=> 1, 'viewport'=>[0.15,0.85,0.15,0.6]
GGraph.line gp.cut('sig'=>1e-4), true

DCL.grcls
