module planck_func_wrapper

  use vtype_module

  implicit none

  private

  public :: Integ_PF_GQ_Array0D
  public :: Integ_PF_GQ_Array1D
  public :: Integ_DPFDT_GQ_Array0D
  public :: Integ_DPFDT_GQ_Array1D


!!$  character(128), save :: ModuleName = 'planck_func_wrapper'


contains

  !--------------------------------------------------------------------------------------

  subroutine Integ_PF_GQ_Array0D( &
    & wn1, wn2, num, &
    & Temp, &
    & pfinted &
    & )

    use planck_func, only : Integ_PF_GQ_Array3D

    real(DP), intent(in ) :: wn1,wn2
    integer , intent(in ) :: num
    real(DP), intent(in ) :: Temp
    real(DP), intent(out) :: pfinted


    !
    ! local variables
    !
    real(DP) :: temp3d   (1:1, 1:1, 1:1)
    real(DP) :: pfinted3d(1:1, 1:1, 1:1)


    temp3d(1,1,1) = Temp
    call Integ_PF_GQ_Array3D( &
      & wn1, wn2, num, &
      & 1, 1, 1, 1, 1, 1, &
      & temp3d, &
      & pfinted3d &
      & )
    pfinted = pfinted3d(1,1,1)


  end subroutine Integ_PF_GQ_Array0D

  !--------------------------------------------------------------------------------------

  subroutine Integ_PF_GQ_Array1D( &
    & wn1, wn2, num, &
    & is, ie, &
    & temp, &
    & pfinted &
    & )

    use planck_func, only : Integ_PF_GQ_Array3D

    real(DP), intent(in ) :: wn1,wn2
    integer , intent(in ) :: num
    integer , intent(in ) :: is
    integer , intent(in ) :: ie
    real(DP), intent(in ) :: temp   (is:ie)
    real(DP), intent(out) :: pfinted(is:ie)


    !
    ! local variables
    !
    real(DP) :: temp3d   (is:ie, 1:1, 1:1)
    real(DP) :: pfinted3d(is:ie, 1:1, 1:1)


    temp3d(:,1,1) = temp(:)
    call Integ_PF_GQ_Array3D( &
      & wn1, wn2, num, &
      & is, ie, 1, 1, 1, 1, &
      & temp3d, &
      & pfinted3d &
      & )
    pfinted(:) = pfinted3d(:,1,1)


  end subroutine Integ_PF_GQ_Array1D

  !--------------------------------------------------------------------------------------

  subroutine Integ_DPFDT_GQ_Array0D( &
    & WN1, WN2, Num,                 & ! (in )
    & Temp,                          & ! (in )
    & DPFDTInted                     & ! (out)
    & )

    ! USE statements
    !
    use planck_func, only : Integ_DPFDT_GQ_Array3D


    real(DP), intent(in ) :: WN1
    real(DP), intent(in ) :: WN2
    integer , intent(in ) :: Num
    real(DP), intent(in ) :: Temp
    real(DP), intent(out) :: DPFDTInted


    !
    ! local variables
    !
    real(DP) :: aaa_Temp      (1:1, 1:1, 1:1)
    real(DP) :: aaa_DPFDTInted(1:1, 1:1, 1:1)


    aaa_Temp(1,1,1) = Temp

    call Integ_DPFDT_GQ_Array3D(      &
      & WN1, WN2, Num,                & ! (in )
      & 1, 1, 1, 1, 1, 1, aaa_Temp, & ! (in )
      & aaa_DPFDTInted                & ! (out)
      & )

    DPFDTInted = aaa_DPFDTInted(1,1,1)


  end subroutine Integ_DPFDT_GQ_Array0D

  !--------------------------------------------------------------------------------------

  subroutine Integ_DPFDT_GQ_Array1D( &
    & WN1, WN2, Num,                 & ! (in )
    & is, ie, a_Temp,                & ! (in )
    & a_DPFDTInted                   & ! (out)
    & )

    ! USE statements
    !
    use planck_func, only : Integ_DPFDT_GQ_Array3D


    real(DP), intent(in ) :: WN1
    real(DP), intent(in ) :: WN2
    integer , intent(in ) :: Num
    integer , intent(in ) :: is
    integer , intent(in ) :: ie
    real(DP), intent(in ) :: a_Temp      (is:ie)
    real(DP), intent(out) :: a_DPFDTInted(is:ie)


    !
    ! local variables
    !
    real(DP) :: aaa_Temp      (is:ie, 1:1, 1:1)
    real(DP) :: aaa_DPFDTInted(is:ie, 1:1, 1:1)


    aaa_Temp(:,1,1) = a_Temp

    call Integ_DPFDT_GQ_Array3D(      &
      & WN1, WN2, Num,                & ! (in )
      & is, ie, 1, 1, 1, 1, aaa_Temp, & ! (in )
      & aaa_DPFDTInted                & ! (out)
      & )

    a_DPFDTInted = aaa_DPFDTInted(:,1,1)


  end subroutine Integ_DPFDT_GQ_Array1D

  !----------------------------------------------------------------------------

end module planck_func_wrapper
