= History

* 2015/06/24 yot


= Summary

Merge splitted files for DCPAM MPI parallelized execution into 
single file. 


= Usage

== Required library

* NetCDF

== Compilation

* Edit Makefile
  * Change following items
    * Fortran compiler
    * path to NetCDF library
* make
  % make

== Execution

* Prepare a configuration file named merge.nml
* Execution
  % merge_ncf


= Configuration file

== Number of processes

Number of processes is specified as follows.

  &proc nprocs = X /

Where, X is number of processes. 


== Input/Output files and variables

Input/Output files and variables are specified as follows. 

  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var1' /
  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var2' /
  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var3' /
  &item inncfn = 'input2.nc', outncfn = 'output2.nc', Varname = 'var4' /
  &item inncfn = 'input3.nc', outncfn = 'output3.nc', Varname = 'var5' /

One line includes one variable. 

* Meaning of each variable is as follows. 
  * inncfn
    Name of input NetCDF file, but does not include rank number. 
    For example, if number of process is 4, and inncfn = 'input.nc', 
    Actual file name is as follows. 

      input_rank000000.nc
      input_rank000001.nc
      input_rank000002.nc
      input_rank000003.nc

    If inncfn is not specified, inncfn = Varname // '.nc' is assumed. 
  * outncfn
    Name of output NetCDF file. 
    If outncfn is not specified, outncfn = inncfn is assumed. 
  * Varname
    Variable name. 

  If value of outncfn in a line is the same as that in a previous line, 
  a variable is output to the same file. 
  If a netcdf file includes several variables and output file include 
  several variables, several lines include the same inncfn and outncfn 
  as is shown above. 
