= 履歴

* 2011/09/09 yot


= 概要

DCPAM で MPI を用いて行った並列計算の結果のプロセスごとの分割ファイルを
一つのファイルにまとめる. 


= 使い方

== 必要なライブラリ

* NetCDF

== コンパイル

* Makefile を編集
  * 以下を指定
    * Fortran コンパイラ
    * NetCDF ライブラリのディレクトリ
* make の実行
  % make

== 実行

* 設定ファイル merge.nml を用意
* 実行
  % merge_ncf


= 設定ファイル

設定ファイル merge.nml には, 
* プロセス数 (分割するファイル数)
* ファイル・変数情報
  * 入力ファイル名
  * 出力ファイル名 (のランク番号を除いたもの)
  * 変数名
を namelist によって設定する. 

== プロセス数

プロセス数は以下のように設定する

  &proc nprocs = X /

ここで, X はプロセス数 (分割するファイル数).

== ファイル・変数情報

ファイル・変数情報は以下のように設定する

一つの変数ごとに下のように一項目設定する.

  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var1' /
  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var2' /
  &item inncfn = 'input1.nc', outncfn = 'output1.nc', Varname = 'var3' /
  &item inncfn = 'input2.nc', outncfn = 'output2.nc', Varname = 'var4' /
  &item inncfn = 'input3.nc', outncfn = 'output3.nc', Varname = 'var5' /

ここで, それぞれの変数の意味は下の通り.
* inncfn
  入力 NetCDF ファイル名のランク番号を除いたもの.
  例えば, プロセス数が 4 で, inncfn = 'input.nc' の時, 
  実際の出力ファイル名は下のようになる.

    input_rank000000.nc
    input_rank000001.nc
    input_rank000002.nc
    input_rank000003.nc

  この変数の指定は省略可能であり, 省略された場合には inncfn = Varname // '.nc' 
  と仮定される.
* outncfn
  出力 NetCDF ファイル名.
  この変数の指定は省略可能であり, 省略された場合には outncfn = inncfn と仮定される.
* Varname
  変数名

outncfn がひとつ前の &item の outncfn と同じ場合, 同じ
出力ファイルに追記される. 
一つの入力ファイルに複数の変数が含まれており, 出力ファ
イルにおいても入力ファイルと同様に複数の変数を含めたい
場合には, 上記の例のように inncfn, outncfn が同じ &item 
ブロック指定を並べる必要がある. 
