!= 地球大気向け放射モデル Ver. 2 ラッパー
!
module rad_Earth_V2_wrapper

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types

  ! 格子点数設定
  !
  use gridset, only : kmax

  implicit none

  private

  public :: RadEarthV2WrapperInit
  public :: RadEarthV2Wrapper1DFlux

  !----------------------------------------------------------------------------

contains

  !----------------------------------------------------------------------------
  ! 初期化
  !----------------------------------------------------------------------------

  subroutine RadEarthV2WrapperInit

    != 地球大気向け放射モデル Ver. 2
    !
    use rad_Earth_V2_mod, only : RadEarthV2Init


    call RadEarthV2Init


  end subroutine RadEarthV2WrapperInit

  !----------------------------------------------------------------------------
  ! フラックス計算モジュールに 1D 変数を渡すためのラッパー
  !----------------------------------------------------------------------------

  subroutine RadEarthV2Wrapper1DFlux( &
    & SolarConst, CosSZA,                                     & ! (in)
    & SurfAlbedo,                                             & ! (in)
    & z_Press, r_Press, z_Temp, SurfTemp,                     & ! (in)
    & z_QH2OVap, z_QCO2, z_QO3, z_QN2O, z_QCH4,               & ! (in)
    & r_RadSUwFlux, r_RadSDwFlux, r_RadLUwFlux, r_RadLDwFlux  & ! (out)
    & )

    ! USE statements
    !

    ! 格子点数設定
    !
    use gridset, only : imax, jmax, kmax

    != 地球大気向け放射モデル Ver. 2
    !
    use rad_Earth_V2_mod, only : RadEarthV2Flux


    real(DP), intent(in ) :: SolarConst
    real(DP), intent(in ) :: CosSZA
    real(DP), intent(in ) :: SurfAlbedo
    real(DP), intent(in ) :: z_Press       (1:kmax)
    real(DP), intent(in ) :: r_Press       (0:kmax)
    real(DP), intent(in ) :: z_Temp        (1:kmax)
    real(DP), intent(in ) :: z_QH2OVap     (1:kmax)
!!$    real(DP), intent(in ) :: z_QH2OLiq     (1:kmax)
!!$    real(DP), intent(in ) :: z_QH2OSol     (1:kmax)
!!$    real(DP), intent(in ) :: z_CloudCover  (1:kmax)
    real(DP), intent(in ) :: z_QCO2          (1:kmax)
    real(DP), intent(in ) :: z_QO3           (1:kmax)
    real(DP), intent(in ) :: z_QN2O          (1:kmax)
    real(DP), intent(in ) :: z_QCH4          (1:kmax)
    real(DP), intent(in ) :: SurfTemp
    real(DP), intent(out) :: r_RadSUwFlux  (0:kmax)
    real(DP), intent(out) :: r_RadSDwFlux  (0:kmax)
    real(DP), intent(out) :: r_RadLUwFlux  (0:kmax)
    real(DP), intent(out) :: r_RadLDwFlux  (0:kmax)


    real(DP) :: xy_CosSZA         (0:imax-1, 1:jmax)
    real(DP) :: xy_SurfAlbedo     (0:imax-1, 1:jmax)
    real(DP) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QH2OLiq       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QH2OSol       (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QCO2          (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QO3           (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QN2O          (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_QCH4          (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_SurfTemp       (0:imax-1, 1:jmax)
    real(DP) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
    real(DP) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)

    integer :: k


    xy_CosSZA       = CosSZA
    xy_SurfAlbedo   = SurfAlbedo
    do k = 1, kmax
      xyz_Press       (:,:,k) = z_Press(k)
    end do
    do k = 0, kmax
      xyr_Press       (:,:,k) = r_Press(k)
    end do
    do k = 1, kmax
      xyz_Temp        (:,:,k) = z_Temp   (k)
      xyz_QH2OVap     (:,:,k) = z_QH2OVap(k)
      xyz_QH2OLiq     (:,:,k) = 0.0d0
      xyz_QH2OSol     (:,:,k) = 0.0d0
      xyz_QCO2        (:,:,k) = z_QCO2(k)
      xyz_QO3         (:,:,k) = z_QO3 (k)
      xyz_QN2O        (:,:,k) = z_QN2O(k)
      xyz_QCH4        (:,:,k) = z_QCH4(k)
      xyz_CloudCover  (:,:,k) = 1.0d0
    end do
    xy_SurfTemp     = SurfTemp

    call RadEarthV2Flux(                                                 &
      & SolarConst, xy_CosSZA,                   & ! (in)
      & xy_SurfAlbedo,                           & ! (in)
      & xyz_Press, xyr_Press, xyz_Temp,          & ! (in)
      & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,   & ! (in)
      & xyz_QCO2, xyz_QO3, xyz_QN2O, xyz_QCH4,   & ! (in)
      & xyz_CloudCover,                          & ! (in)
      & xy_SurfTemp,                             & ! (in)
      & xyr_RadSUwFlux, xyr_RadSDwFlux,          & ! (out)
      & xyr_RadLUwFlux, xyr_RadLDwFlux,          & ! (out)
      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux   & ! (out)
      & )

    do k = 0, kmax
      r_RadSUwFlux(k) = xyr_RadSUwFlux   (0,1,k)
      r_RadSDwFlux(k) = xyr_RadSDwFlux   (0,1,k)
      r_RadLUwFlux(k) = xyr_RadLUwFlux   (0,1,k)
      r_RadLDwFlux(k) = xyr_RadLDwFlux   (0,1,k)
    end do


  end subroutine RadEarthV2Wrapper1DFlux

  !----------------------------------------------------------------------------

end module rad_Earth_V2_wrapper
