!= dcrtm inital profile data 作成プログラム
!
!= dcrtm initial profile data making program
!
! Authors::   Masanori Onishi
! Version::   $Id: initialdata.f90,v 1.00 onishi$
! Tag Name::  $Name: dcrtm-20161021 $
! Copyright:: Copyright (C) GFD Dennou Club, 2016. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]

program initialdata
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !

  ! モジュール引用 ; USE statements
  !

  ! netcdf データ入出力
  ! netcdf data input or output
  !
  use gtool_history

  ! 宣言文 ; Declaration statements
  !
  implicit none

  ! 設定変数, 他
  ! setteing parameter, values
  !
  integer :: fi = 11
  integer :: fnml = 12
  character(99) :: InFilePTX
  character(99) :: InFileMolWt
  character(99) :: OutFileName
  integer :: kmax, k_r
  integer :: mmax, k_m
  real(8), allocatable :: r_Press(:)
  real(8), allocatable :: r_Temp (:)
  real(8), allocatable :: rm_MixRatio(:,:)
  integer, allocatable :: m_MolNum(:)
  real(8), allocatable :: m_MolWt(:)
  character( 2) :: charMMAX
  character( 6) :: charUNIT
  character(99) :: charDMMY

  ! namelist file の設定
  ! setting of namelist file
  !
  namelist /initial_nml/ &
    & InFilePTX,     &
    & InFileMolWt,   &
    & OutFileName

  ! namelist file の読み込み
  ! read namelist file
  !
  open(fnml, file='dcrtm.nml')
  read(fnml, nml=initial_nml)
  close(fnml)
  print *, InFilePTX, InFileMolWt, OutFileName

  open(fi, file=InFIlePTX)
  read(fi, *)
  read(fi, *) mmax, kmax

  kmax = kmax - 1

  print *, mmax, kmax

  allocate( r_Press    (0:kmax        ) )
  allocate( r_Temp     (0:kmax        ) )
  allocate( rm_MixRatio(0:kmax, 1:mmax) )
  allocate( m_MolNum   (        1:mmax) )
  allocate( m_MolWt    (        1:mmax) )

  do k_m = 1, mmax
    m_MolNum(k_m) = k_m
  end do

  read(fi, *) charDMMY
  read(fi, '(a)') charDMMY

  print *, charDMMY

  charUNIT(1:6) = charDMMY(23:28)
  print *, charUNIT

  do k_r = 0, kmax
    read(fi, *) r_Press(k_r), r_Temp(k_r)
    print *, 'PT'
    print *, r_Press(k_r), r_Temp(k_r)

    print *, 'X'
    read(fi, *) rm_MixRatio(k_r,1:mmax)
    print *, rm_MixRatio(k_r,1:mmax)

  end do

  close(fi)


  if(charUNIT == '[   1]') then
    print *, charUNIT
  elseif(charUNIT == '[PPMV]') then
    print *, charUNIT
    rm_MixRatio = rm_MixRatio*1d-6
  else
    print *, 'Unit of volume mixing ratio is unknown:', charUNIT
    print *, 'stop'
    stop
  end if

  open(fi, file=InFileMolWt)
  read(fi, *) CharDMMY! number of spieces
  read(fi, *) CharDMMY! 22 
  read(fi, *) CharDMMY ! molecular weight

  do k_m = 1, mmax
    read(fi, *) CharDMMY ! character of molecule
    read(fi, *) m_MolWt(k_m)
    print *, m_MolWt(k_m)
  end do

  call HistoryCreate(                              &
    & file=''//OutFileName//'',        &
    & title=''//OutFileName//'', &
    & source=''//InFilePTX//'',&
    & institution='DCRTM',                         &
    & dims=(/'r_Press ','m_MolNum'/), dimsizes=(/kmax+1,mmax/),           &
    & longnames=(/'pressure        ', 'molecular number'/),                    &
    & units=(/'Pa', '1 '/)                    )

  call HistoryPut('r_Press',r_Press)
  call HistoryPut('m_MolNum',m_MolNum)

  call HistoryAddVariable( &
    & varname='r_Temp', dims=(/'r_Press'/), &
    & longname='temperature', units='K', xtype='double')
  call HistoryPut('r_Temp',r_Temp)

  call HistoryAddVariable( &
    & varname='m_MolWt', dims=(/'m_MolNum'/), &
    & longname='molecular weight', units='kg mol-1', xtype='double')
  call HistoryPut('m_MolWt',m_MolWt)

  call HistoryAddVariable( &
    & varname='rm_MixRatio', dims=(/'r_Press ', 'm_MolNum'/), &
    & longname='volume mixing ratio', units='1', xtype='double')
  call HistoryPut('rm_MixRatio',rm_MixRatio)

  call HistoryClose


end program initialdata
