!= continumm absorption calculation module
!
!= continuum absorption calculation module
!
! Authors::   Masanori Onishi
! Version::   $Id: main_dcrtm.f90,v 1.00 onishi$
! Tag Name::  $Name: dcrtm-20160713 $
! Copyright:: Copyright (C) GFD Dennou Club, 2016. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]


module mod_contabs

  implicit none

  private

  public :: cont_absorpk

contains

  subroutine cont_absorpk(          & !2016/06/21
    & Flag_CONT, mmax, kmax,        & !(in )
    & r_Press, r_Temp, rm_MixRatio, & !(in )
    & m_MolWt, MinWN, MaxWN, ResWN, & !(in )
    & alpha,                        & !(in )
    & rmw_CAbsorpk                  ) !(out)
    !
    !
    !
    !
    integer, intent(in ) :: Flag_CONT
    integer, intent(in ) :: mmax
    integer, intent(in ) :: kmax
    real(8), intent(in ) :: r_Press    (0:kmax) ![Pa]
    real(8), intent(in ) :: r_Temp     (0:kmax) ![K]
    real(8), intent(in ) :: rm_MixRatio(0:kmax, 0:  50)
    real(8), intent(in ) :: m_MolWt    (        0:mmax)
    real(8), intent(in ) :: MinWN ![m-1]
    real(8), intent(in ) :: MaxWN ![m-1]
    real(8), intent(in ) :: ResWN ![m-1]
    real(8), intent(in ) :: alpha ![kg2 m-4 molecule-1]
    real(8), intent(out) :: rmw_CAbsorpk(0:kmax,0:mmax,0:int((MaxWN-MinWN)/ResWN))

    if(Flag_CONT .ne. 0) then

      print *, '"This program does not support Flag_CONT /= 0 because continuum is not calculated."'
      print *, 'program stop'
      stop

    else

      rmw_CAbsorpk = 0.0_8

    end if

  end subroutine cont_absorpk

end module mod_contabs
