!= 格子点設定プログラム
!
!= grid point setting program
!
! Authors::   Masanori Onishi
! Version::   $Id: main_dcrtm.f90,v 0.00 onishi$
! Tag Name::  $Name: dcrtm-20150331 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2015. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]

module gridset
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !

  ! 宣言文 ; Declaration statements
  !
  implicit none

  private

  public :: GridsetSet
  public :: GridsetPrint


  integer, save, public:: imax = 1
                              ! 経度格子点数.
                              ! Number of grid points in longitude
  integer, save, public:: jmax = 1
                              ! 緯度格子点数.
                              ! Number of grid points in latitude
  integer, save, public:: kmax = 1
                              ! 鉛直層数.
                              ! Number of vertical level

contains

  subroutine GridsetSet(InImax, InJmax, InKmax)
    !
    ! 格子点設定
    ! grid point setting
    !
    integer, intent(in) :: InImax
    integer, intent(in) :: InJmax
    integer, intent(in) :: InKmax

    imax = InImax
    jmax = InJmax
    kmax = InKmax

  end subroutine GridsetSet

  subroutine GridsetPrint
    !
    ! 格子点出力
    ! grid point output
    !
    print *, 'imax:', imax
    print *, 'jmax:', jmax
    print *, 'kmax:', kmax

  end subroutine GridsetPrint

end module gridset
