!= 物理定数・惑星定数設定プログラム
!
!= physical constants, planetary constants setting program
!
! Authors::   Masanori Onishi
! Version::   $Id: main_dcrtm.f90,v 0.00 onishi$
! Tag Name::  $Name: dcrtm-20150331 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2015. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]

module planetconst
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !

  ! 宣言文 ; Declaration statements
  !
  implicit none

  private

  real(8), public :: LightSpeed = 2.99792458e+8_8
                              ! 光速 [m s-1]
                              ! Light Speed [m s-1]
                              ! CODATA 2010
  real(8), public :: PlanckConst = 6.62606957e-34_8
                              ! プランク定数 [J s]
                              ! planck constant [J s]
                              ! CODATA 2010
  real(8), public :: BoltzmannConst = 1.3806488e-23_8
                              ! ボルツマン定数 [J K-1]
                              ! boltzmann constant [J K-1]
                              ! CODATA 2010
  real(8), public :: AvogadroNum = 6.02214129e+23_8
                              ! アヴォガドロ数 [mol-1]
                              ! avogadro number [mol-1]
                              ! CODATA 2010 
  real(8), public :: SecRadConst = 6.62606957e-34_8 * 2.99792458e+8_8 / 1.3806488e-23_8
                              ! Second Radiation Constant (hc/k) [m K]
                              !
  real(8), public :: Grav = 9.80665_8
                              ! 重力加速度 [m s-2]
                              ! standard acceleration of gravity [m s-2]
                              ! WMO technical regulations

end module planetconst
