!= 
!
!= Prepare initial surface data
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module initial_surface_data
  !
  != 
  !
  != Prepare initial surface data
  !
  ! 初期値データのサンプルを提供します. 
  !
  ! Prepare sample data of initial surface data (restart data)
  !
  !== Procedures List
  !
  ! SetInitSurfaceData :: 初期値データ取得
  ! ------------------ :: ------------
  ! SetInitSurfaceData :: Get initial surface data
  !
  !== NAMELIST
  !
  ! NAMELIST#initial_surface_data_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数. 
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数. 
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数. 
                             ! Number of vertical level

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING     ! 文字列.       Strings. 

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP     ! 倍精度実数型. Double precision. 

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public:: SetInitSurfaceData
  public:: InitSurfaceDataInit

  ! 公開変数
  ! Public variables
  !
  logical, save, public:: initial_surface_data_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag

  real(DP), save       :: SoilMoist
                              ! soil moisture (kg m-2)
  real(DP), save       :: SurfSnow
                              ! surface snow (kg m-2)
  real(DP), save       :: SOSeaIceMass
                              ! slab sea ice mass (kg m-2)
  real(DP), save       :: SurfMajCompIce
                              ! surface major component ice (kg m-2)

  ! 非公開変数
  ! Private variables
  !

  character(*), parameter:: module_name = 'initial_surface_data'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: initial_surface_data.f90,v 1.2 2015/01/29 12:05:42 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetInitSurfaceData(                                    &
    & xy_SurfMajCompIce, xy_SoilMoist, xy_SurfSnow, xy_SOSeaIceMass & ! (out)
    & )
    !
    ! 初期値データのサンプルを提供します. 
    ! 
    ! Prepare sample data of initial data
    !

    ! モジュール引用 ; USE statements
    !

    ! 物理・数学定数設定
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $.
                              ! 円周率. Circular constant

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . 経度. Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . 緯度. Latitude
      & z_Sigma
                              ! $ \sigma $ レベル (整数). 
                              ! Full $ \sigma $ level

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: LChar

    ! ファイルから 1 次元プロファイルを読んで設定する. 
    ! read 1-D profile from a file and set it 
    !
    use set_1d_profile, only : Set1DProfilePs, Set1DProfileAtm


    ! 宣言文 ; Declaration statements
    !
    implicit none

    real(DP), intent(out):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
                            ! 
                            ! surface major component ice
    real(DP), intent(out):: xy_SoilMoist(0:imax-1, 1:jmax)
                            ! 
                            ! soil moisture
    real(DP), intent(out):: xy_SurfSnow(0:imax-1, 1:jmax)
                            ! 
                            ! surface snow amount
    real(DP), intent(out):: xy_SOSeaIceMass(0:imax-1, 1:jmax)
                            ! 
                            ! slab sea ice mass

    ! 作業変数
    ! Work variables
    !

    integer:: i               ! 経度方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in longitude
    integer:: j               ! 緯度方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in latitude
    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in vertical direction

    ! 実行文 ; Executable statement

    if ( .not. initial_surface_data_inited ) call InitSurfaceDataInit

    do j = 1, jmax
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SurfMajCompIce(:,j) = 0.0_DP
!!$      else
        xy_SurfMajCompIce(:,j) = SurfMajCompIce
!!$      end if
        !
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SoilMoist(:,j) = 0.0_DP
!!$      else
        xy_SoilMoist(:,j) = SoilMoist
!!$      end if
        !
!!$      if ( y_Lat(j) * 180.0_DP / PI > 0.0_DP ) then
!!$        xy_SurfSnow(:,j) = 0.0_DP
!!$      else
        xy_SurfSnow(:,j) = SurfSnow
!!$      end if
    end do

    xy_SOSeaIceMass = SOSeaIceMass


  end subroutine SetInitSurfaceData

  !--------------------------------------------------------------------------------------

  subroutine InitSurfaceDataInit

    ! モジュール引用 ; USE statements
    !

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: LChar

    ! 宣言文 ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /initial_surface_data_nml/ &
      & SoilMoist, SurfSnow, SOSeaIceMass, SurfMajCompIce
          !
          ! デフォルト値については初期化手続 "initial_surface_data#InitSurfaceDataInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "initial_surface_data#InitSurfaceDataInit" for the default values. 
          !


    ! 実行文 ; Executable statement

    if ( initial_surface_data_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !
    SoilMoist      = 0.0_DP
    SurfSnow       = 0.0_DP
    SOSeaIceMass   = 0.0_DP
    SurfMajCompIce = 0.0_DP

    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                     ! (in)
        & nml = initial_surface_data_nml, & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  SoilMoist      = %f', d = (/ SoilMoist /) )
    call MessageNotify( 'M', module_name, '  SurfSnow       = %f', d = (/ SurfSnow /) )
    call MessageNotify( 'M', module_name, '  SOSeaIceMass   = %f', d = (/ SOSeaIceMass   /) )
    call MessageNotify( 'M', module_name, '  SurfMajCompIce = %f', d = (/ SurfMajCompIce /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    initial_surface_data_inited = .true.

  end subroutine InitSurfaceDataInit

  !--------------------------------------------------------------------------------------

end module initial_surface_data
