=begin JA

= dcpam5 リリースのための作業

# * 森川 靖大 (morikawa), 高橋 芳幸 (yot)
#   * $Id: release.rd,v 1.1 2009/04/05 14:32:36 morikawa Exp $

=end JA

=begin JA

本文書は dcpam5 をリリースする際に必要な一連の手順について記します. 

== 概要

ここでのリリースとは, dcpam5 のソースやドキュメントに関して, 
ある時点でバージョンを設定し, そのバージョンでのパッケージを作成して, 
Web 上からパッケージのダウンロードやソースコードの参照を行えるようにすることです. 
バージョンの設定には Git のタグ機能を利用します. 
dcpam5 の公開場所は, 
((<地球流体電脳倶楽部サーバ|URL:http://www.gfd-dennou.org>)) の
((<DCPAM プロジェクト|URL:http://www.gfd-dennou.org/library/dcpam>))
です. 

以下では, リリースまでの作業を記します. 
作業を大まかに分けると, 

  (1) ((<リリースに際して更新すべきファイルの編集と Git コミット>))
  (2) ((<Git タグの設定>))
  (3) ((<公開領域でのパッケージの作成>))

となります. 

== リリースに際して更新すべきファイルの編集と Git コミット

=== HISTORY の更新

((<HISTORY|URL:../../HISTORY>)) ファイルを更新します.
HISTORY ファイルは RD 形式のテキストとして管理されています. 
編集方法に関しては
((<dcpam5 ドキュメントの概説と保守管理の解説|URL:doc-overview.htm>))
の ((*rdtool を用いたドキュメントの保守管理*)) を参照してください. 
HISTORY ファイルに, 以下のように日英両方で, 
前バージョンと最新バージョンとの変更点の概要を記載してください. 
新しい情報を上に記載するようにしてください. 
また, ((*Tags:*)) の後ろに記述する文字列は, 
下記 ((<Git タグの設定>)) で指定する Git タグと同じにして下さい. 
Git タグについては
((<"ftp/arch/dcpam/ ディレクトリのメンテナンス手引"|URL:http://www.gfd-dennou.org/library/dcpam/TEBIKI.dcpam.htm>))
の ((*Git タグの付け方*)) を参照してください. 

  =begin
  == 2009/03/25 (Tag: dcpam5-20090325)
  =end

  =begin JA
  * データ入出力に関するバグを修正.
  * 力学過程に関するコード解説文書の追加. 
  =end JA
  =begin EN
  * Bugs about data I/O are fixed.
  * Code descriptions about a dynamical process are added. 
  =end EN

追記後, HISTORY ファイルを Git コミットしてください. 
コミットメッセージは, 例えば以下のようにします. 

  　
  * Update on 2009/03/25

  * 2009/03/25 の更新


=== ChangeLog の更新

((<ChangeLog|URL:../../ChangeLog>)) ファイルを更新します.
((<dcpam5 ドキュメントの概説と保守管理の解説|URL:doc-overview.htm>))
の ((*ChangeLog の保守管理*)) を参照し, ChangeLog ファイルを更新してください.

更新後, ChangeLog ファイルを Git コミットしてください. 
コミットメッセージは, 例えば以下のようにします. 

  　
  * Update on 2009/03/25

  * 2009/03/25 の更新


== Git タグの設定

((<"ftp/arch/dcpam/ ディレクトリのメンテナンス手引"|URL:http://www.gfd-dennou.org/library/dcpam/TEBIKI.dcpam.htm>))
の ((*Git タグの付け方*)) を参照して, Git タグを設定してください. 

Git タグを設定してください. 

#  > git tag -a <tagname> -m <message>
#
#<tagname> は通常, dcpam5-yyyymmdd (例えば, dcpam5-20150101) とする.
#<message> は例えば, "Snapshot on yyyy/mm/dd." とする.

タグを設定したらタグを含めて push します.

  > git push --tags origin master

以上で, Git 作業コピー内での作業は終了です. 


== 公開領域でのパッケージの作成

この作業については, 
((<"ftp/arch/dcpam/ ディレクトリのメンテナンス手引"|URL:http://www.gfd-dennou.org/library/dcpam/TEBIKI.dcpam.htm>))
を参照して, 電脳サーバ上で作業を進めてください. 

ページ中でリリース作業に関して主に参照すべきなのは以下の項目です. 

* ((<dcpam ソースの展開とシンボリックリンクの方針|URL:http://www.gfd-dennou.org/library/dcpam/TEBIKI.dcpam.htm#label-4>))
* ((<ソース展開の手順 (手動)|URL:http://www.gfd-dennou.org/library/dcpam/TEBIKI.dcpam.htm#label-7>))


=end JA 

=begin HTMLJA
<hr />
<small>
  $Id: release.rd,v 1.1 2009/04/05 14:32:36 morikawa Exp $
</small>
=end HTMLJA
