!= 太陽放射フラックスの設定
!
!= Set solar constant
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_solarconst
  !
  != 太陽放射フラックスの設定
  !
  != Set solar constant
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== References
  !
!!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
!!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
!!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
!!$  ! RadiationFluxOutput     :: 放射フラックスの出力
!!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#set_solarconst_nml
  !

  ! USE statements
  !

  ! 
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify


  ! Declaration statements
  !
  implicit none
  private

  ! 
  ! Public procedure
  !
  public:: SetSolarConst
  public:: SetSolarConstInit


  character(*), parameter:: module_name = 'set_solarconst'
                              ! モジュールの名称.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

  real(DP), save         :: SolarConst

  character(STRING), save:: SolarConstFile
  character(STRING), save:: SolarConstVarName

  logical, save :: set_solarconst_inited = .false.
                              ! 初期設定フラグ.
                              ! Initialization flag

contains

  !--------------------------------------------------------------------------------------

  subroutine SetSolarConst( &
    & SolarFlux             & ! (out)
    & )


    ! USE statements
    !

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! 時刻管理
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ステップ $ t $ の時刻.
                              ! Time of step $ t $.
      & TimesetClockStart, TimesetClockStop

    ! 時系列データの読み込み
    ! Reading time series
    !
    use read_time_series, only: SetValuesFromTimeSeriesWrapper


    real(DP), intent(out):: SolarFlux


    !
    ! Work variables
    !


    ! 初期化確認
    ! Initialization check
    !
    if ( .not. set_solarconst_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! 計算時間計測開始
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    if ( SolarConstFile == '' ) then

      SolarFlux = SolarConst

    else

      call SetValuesFromTimeSeriesWrapper(   &
        & "SolarConst",                      &
        & SolarConstFile, SolarConstVarName, &
        & SolarFlux                          & ! (inout)
        & )

    end if


    call HistoryAutoPut( TimeN, "SolarConst", SolarFlux )


    ! 計算時間計測一時停止
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine SetSolarConst

  !--------------------------------------------------------------------------------------

  subroutine SetSolarConstInit


    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid


    !
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /set_solarconst_nml/ &
      & SolarConst,     &
      & SolarConstFile, &
      & SolarConstVarName
          !
          ! デフォルト値については初期化手続 "set_solarconst#SetSolarConstInit"
          ! のソースコードを参照のこと.
          !
          ! Refer to source codes in the initialization procedure
          ! "set_solarconst#SetSolarConstInit" for the default values.
          !

    if ( set_solarconst_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !

!!$    SolarConst     = 1380.0_DP
    SolarConst        = 1366.0_DP

    SolarConstFile    = ''
    SolarConstVarName = "SolarConst"


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_solarconst_nml,       & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    call HistoryAutoAddVariable( "SolarConst", & ! (in)
      & (/ 'time' /),                          & ! (in)
      & "solar constant", 'W m-2' )              ! (in)

    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  SolarConst        = %f', d = (/ SolarConst /) )
    call MessageNotify( 'M', module_name, '  SolarConstFile    = %c', c1 = trim( SolarConstFile ) )
    call MessageNotify( 'M', module_name, '  SolarConstVarName = %c', c1 = trim( SolarConstVarName ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    set_solarconst_inited = .true.

  end subroutine SetSolarConstInit

  !--------------------------------------------------------------------------------------

end module set_solarconst
