#!/bin/sh
#
#= Setup a directory for a experiment
#
# Authors::   Shin-ichi Takehiro, Yasuhiro MORIKAWA
# Version::   $Id: setup_expdir_nonstd.sh,v 1.1 2012/02/23 23:09:47 takepiro Exp $
# Tag Name::  $Name:  $
# Copyright:: Copyright (C) GFD Dennou Club, 2012. All rights reserved.
# License::   See COPYRIGHT[link:./COPYRIGHT]
#
######################################################################
#
#== Settings

DEFAULT_DIRNAME=${DEFAULT_DIRNAME:-}
DEFAULT_DIRNAME_PRE="test"
DEFAULT_UPDATE="N"
#DCPAMDIR=${DCPAMDIR:-..}
DCPAMDIR=${DCPAMDIR:-.}
DEFAULT_EXECDIR=${DEFAULT_EXECDIR:-${DCPAMDIR}/src/main}
DEFAULT_NMLDIR=${DEFAULT_NMLDIR:-${DCPAMDIR}/exp_setup_files}
DEFAULT_NMLDIR=${DEFAULT_NMLDIR:-${DEFAULT_EXECDIR}}
DEFAULT_SRCDIR=${DEFAULT_SRCDIR:-${DCPAMDIR}/src}
DEFAULT_CONFIGMK=${DEFAULT_CONFIGMK:-${DCPAMDIR}/Config.mk}

DCPAMDIRFULLPATH=`pwd`
DCPAMINCDIR=${DCPAMDIRFULLPATH}/include
DCPAMLIBDIR=${DCPAMDIRFULLPATH}/lib
DCPAMSCRIPTDIR=${DCPAMDIRFULLPATH}/script

NMLFILE_SUFFIX="conf"
DEFAULT_SAVESRC="N"
SRCFILE_FIND="*.[fF]9[05] Makefile depend"
SRCFILE_BACKUPDIR="src_backup"

INSTALL=${INSTALL:-cp}
INSTALLBIN=${INSTALLBIN:-cp}
INSTALLDIR=${INSTALLDIR:-"mkdir -p"}

VERBOSE=${VERBOSE:-}

NONINTERACTIVE=${NONINTERACTIVE:-}

# End Settings
######################################################################

######################################################################
#== Functions

print_msg() {
    if [ -n "$VERBOSE" ]; then
	echo $*
    else
	echo $ECHO_N ".$ECHO_C"
    fi
}

backup_oldfile() {
    local suf='.bak.'
    local num=00
    local pathname=$1
    if [ ! -e "${pathname}" ]; then
	echo ""
	echo "  Error: \"${pathname}\" is not found."
	echo ""
    fi
    while [ -e "${pathname}${suf}${num}" ]; do
	num=`expr $num + 1`
	if [ $num -lt 10 ]; then
	    num=0${num}
	fi
    done
    mv ${pathname} ${pathname}${suf}${num}
}

update_file() {
    local srcpath=$1
    local dstdir=$2
    local exec=$3
    if [ -n "${exec}" ]; then
	local install="${INSTALLBIN}"
    else
	local install="${INSTALL}"
    fi
    srcfile=`basename ${srcpath}`
    if [ -f "${dstdir}/${srcfile}" ]; then
	if [ "${srcpath}" -nt "${dstdir}/${srcfile}" ]; then
	    echo "    Updating \"${dstdir}/${srcfile}\""
	    backup_oldfile "${dstdir}/${srcfile}"
	    ${install} ${srcpath} ${dstdir}
	fi
    else
	print_msg "    Copying ${srcpath} -> ${dstdir}/${srcfile}"
	${install} ${srcpath} ${dstdir}
    fi
}

create_mk_top(){
    local mkfile=$1
    test -n $mkfile || return
    cat > $mkfile <<EOF
#= Makefile for $expdir
######################################################################
#
#== Settings

DIRDEPTH=.
INCLUDEFILE = \$(DIRDEPTH)/Config.mk
include \$(INCLUDEFILE) # Include file              (optional)

# End Settings
#
#== Rules
#
all:
	cd src || exit 1; \$(MAKE)

install: all
	cd src || exit 1; \$(MAKE) \$@

clean: 
	cd src || exit 1; \$(MAKE) \$@

clean.all: 
	cd src || exit 1; \$(MAKE) \$@
	-\$(RM) \$(BINDIR)/*

depend: 
	cd src || exit 1; \$(MAKE) \$@

clean.depend: 
	cd src || exit 1; \$(MAKE) \$@

EOF
}

create_mk_src(){
    local mkfile=$1
    local dirname=$2
    test -n $mkfile || return
    subdirnames=''
    for file in `ls ${dirname}`; do
	test -d "${dirname}/${file}" && test ${file} != 'main' || continue
	subdirnames=${subdirnames}' '${file}
    done
    cat > $mkfile <<EOF
#= Makefile for $expdir/src
######################################################################
#
#== Settings

DIRDEPTH=..
INCLUDEFILE = \$(DIRDEPTH)/Config.mk
include \$(INCLUDEFILE) # Include file              (optional)

LIBDIRS		=${subdirnames}
RUNDIRS		= main

# End Settings
######################################################################
#
#== Rules
#
all: lib exec

lib:
	@for i in \$(LIBDIRS) ; do \\
	  cd \$\$i || exit 1; \\
	  \$(MAKE) || exit 1; \\
	  cd .. ; \\
	done

exec:
	@for i in \$(RUNDIRS) ; do \\
	  cd \$\$i || exit 1; \\
	  \$(MAKE) || exit 1; \\
	  cd .. ; \\
	done

install: 
	cd main ; make \$@

depend: 
	@for i in \$(LIBDIRS) \$(RUNDIRS) ; do \\
	  cd \$\$i || exit 1; \\
	  \$(MAKE) \$@ || exit 1; \\
	  cd .. ; \\
	done

clean: depend.touch
	@for i in \$(LIBDIRS) \$(RUNDIRS) ; do \\
	  cd \$\$i || exit 1; \\
	  \$(MAKE) \$@ || exit 1; \\
	  cd .. ; \\
	done

clean.all: depend.touch
	@for i in \$(LIBDIRS) \$(RUNDIRS) ; do \\
	  cd \$\$i || exit 1; \\
	  \$(MAKE) clean || exit 1; \\
	  cd .. ; \\
	done

depend.touch:
	@for i in \$(LIBDIRS) \$(RUNDIRS) ; do \\
	  touch \$\${i}/depend; \\
	done

clean.depend: 
	@for i in \$(LIBDIRS) \$(RUNDIRS) ; do \\
	  \$(RM) \$\${i}/depend; \\
	done

EOF
}

create_mk_src_main(){
    local mkfile=$1
    local dirname=$2
    test -n $mkfile || return
    objs=''
    bins=''
    for file in `ls ${dirname}/*.f90`; do
	test -f "${file}" || continue
	rootname=`basename ${file} .f90`
	objs=${objs}' '${rootname}.o
	bins=${bins}' '${rootname}
    done
    for file in `ls ${dirname}/*.F90`; do
	test -f "${file}" || continue
	rootname=`basename ${file} .F90`
	objs=${objs}' '${rootname}.o
	bins=${bins}' '${rootname}
    done

    cat > $mkfile <<EOF
#= Makefile for $expdir/src/main
#
######################################################################
#
#== Settings

DIRDEPTH=../..
INCLUDEFILE = \$(DIRDEPTH)/Config.mk
include \$(INCLUDEFILE)

OBJS =${objs}

BINS =${bins}

TESTS =
CLEAN_TESTS = 

TMPFILES = 

RUBYLIB = \$(RUBYF90LIB)
RB2F90 =

# End Settings
######################################################################

######################################################################
#== Rules

all: \$(OBJS) \$(BINS) \$(TESTS)

include \$(DIRDEPTH)/rules.make

clean.all: clean clean.lib

test: all

install: \$(BINS)
	@for i in \$(BINS) ; do \\
	  \$(INSTALLBIN) \$\$i \$(BINDIR) ;\\
	  echo \$(INSTALLBIN) \$\$i \$(BINDIR) ;\\
	done

include depend

#=== rb2f90
EOF
}

create_mk_src_subdir(){
    local mkfile=$1
    local dirname=$2
    test -n $mkfile || return
    objs=''
    for file in `ls ${dirname}/*.f90`; do
	test -f "${file}" || continue
	rootname=`basename ${file} .f90`
	objs=${objs}' '${rootname}.o
    done
    for file in `ls ${dirname}/*.F90`; do
	test -f "${file}" || continue
	rootname=`basename ${file} .F90`
	objs=${objs}' '${rootname}.o
    done

    cat > $mkfile <<EOF
#= Makefile for ${dirname}
#
######################################################################
#
#== Settings

DIRDEPTH=../..
INCLUDEFILE = \$(DIRDEPTH)/Config.mk
include \$(INCLUDEFILE)

OBJS =${objs}

TESTS = 
CLEAN_TESTS = \$(TESTS:%.sh=%.o) \$(TESTS:%.sh=%)

TMPFILES =

RUBYLIB = \$(RUBYF90LIB)
RB2F90 = 

# End Settings
######################################################################

######################################################################
#== Rules

#all: \$(LIBDIR)/\$(DCPAMLIB)
all: \$(OBJS)

include \$(DIRDEPTH)/rules.make

clean.all: clean clean.lib

include depend

#=== rb2f90
EOF
}

create_mk_Configmk(){
    local configmk=$1
    sed -e "s+^SYSFFLAGS.*\$+\0 -I${DCPAMINCDIR}+"     \
	-e "s+^SYSLDFLAGS.*\$+\0 -L${DCPAMLIBDIR}+"    \
	-e "s/SYSLDLIBS=/SYSLDLIBS=-l\$(LIBNAME) /"     \
	-e "s+^SCRIPTDIR.*\$+SCRIPTDIR       = ${DCPAMSCRIPTDIR}+" \
	< ${DEFAULT_CONFIGMK} > $configmk
}

# End Functions
######################################################################

set -e

######################################################################
#== Check echo options
case `echo "testing\c"; echo 1,2,3`,`echo -n testing; echo 1,2,3` in
  *c*,-n*) ECHO_N= ECHO_C='
' ECHO_T='      ' ;;
  *c*,*  ) ECHO_N=-n ECHO_C= ECHO_T= ;;
  *)       ECHO_N= ECHO_C='\c' ECHO_T= ;;
esac

######################################################################
#== Start
echo ""
echo "****** Setup a directory for a experiment ******"
echo ""

######################################################################
#== Specify directory for a experiment

expdirname=''
#if [ -z "${NONINTERACTIVE}" ]; then
    echo $ECHO_N "  Enter top directory name [${topdirname_auto}]: $ECHO_C"
    read topdirname
    test -n "$topdirname" || topdirname=$topdirname_auto

    echo $ECHO_N "  Enter experimet directory name [${nonstddirname_auto}]: $ECHO_C"
    read nonstddirname

    nonstddir="${topdirname}/${nonstddirname}"

    if [ ! -e "$nonstddir" ] || [ ! -d "$nonstddir" ]; then
	echo ""
	echo "  Error: \"${nonstddir}\" not exist."
	echo ""
	exit 1
    fi

    expdir="${topdirname}/${nonstddirname}"

#    if [ -z "${DEFAULT_DIRNAME}" ]; then
#	num=00
#	expdirname_auto=${DEFAULT_DIRNAME_PRE}${num}
#	while [ -e "${nonstddir}/${expdirname_auto}" ]; do
#	    num=`expr $num + 1`
# 	    if [ $num -lt 10 ]; then
# 		num=0${num}
# 	    fi
# 	    expdirname_auto=${DEFAULT_DIRNAME_PRE}${num}
# 	done
#     else
# 	expdirname_auto=${DEFAULT_DIRNAME}
#     fi
#
#    echo $ECHO_N "  Enter experiment directory name [${expdirname_auto}]: $ECHO_C"
#     read expdirname
#     test -n "$expdirname" || expdirname=${expdirname_auto}
#     dirnum=0
#     for dn in $expdirname; do
# 	dirnum=`expr $dirnum + 1`
#     done
#     if [ $dirnum -gt 1 ]; then
# 	echo ""
# 	echo "  Error: \"${expdirname}\" is irrelevant for directory name."
# 	echo ""
# 	exit 1
#     fi
#     expdir="${topdirname}/${nonstddirname}/${expdirname}"
#else
#    topdirname=$topdirname_auto
#    expdirname="${topdirname}/${expdirname_auto}"
#fi
    
if [ -e "$expdir" ] && [ -d "$expdir" ]; then
    echo ""
    echo "*** \"${expdir}\" is already exist ***"
    echo ""

#     echo $ECHO_N "  Update directory \"$expdir\" ? [y/N]: $ECHO_C"
#     read update
#     test -n "$update" || update=$DEFAULT_UPDATE
#     case $update in
# 	y*|Y*) ;;
# 	n*|N*)
# 	    echo ""
# 	    echo "*** Existing update of \"${expdir}\" ***"
# 	    echo ""
# 	    exit 0
# 	    ;;
# 	*)
# 	    update=''
# 	    echo "  Enter yes or no"
# 	    ;;
#     esac

elif [ -e "$expdir" ]; then
    echo ""
    echo "  Error: \"${expdir}\" is not directory."
    echo ""
    exit 1
fi

######################################################################
#== Search non-standard source directory and files
nonstdsrcdir="${nonstddir}/src"
#if [ -z "${NONINTERACTIVE}" ]; then
    echo "  Directory in which non-standard files are prepared"
    echo $ECHO_N "    [${nonstdsrcdir}]: $ECHO_C"
    if [ ! -d "$nonstdsrcdir" ]; then
	echo ""
	echo "  Error: non-standard src directory not found."
	echo ""
	exit 1
    fi
#else
#    execdir=$DEFAULT_EXECDIR
#fi
ls "$nonstdsrcdir" > /dev/null
#echo $execdir

nonstdsrcsubdirnamelist=''
nonstdsrcfilelist=''
for nonstdsrcsubdir in `ls "$nonstdsrcdir"`; do
    test -d "${nonstdsrcdir}/${nonstdsrcsubdir}" || continue
    nonstdsrcsubdirnamelist=$nonstdsrcsubdirnamelist' '$nonstdsrcsubdir
done

# if [ -z "$execpathlist" ]; then
#     echo ""
#     echo "  Error: executable files are not found in \"$execdir\"."
#     echo "         Build executable files on ahead."
#     echo ""
#     exit 1
# fi

######################################################################
# #== Search non-standard NAMELIST directory
# confdir="${nonstddir}/conf"
# #if [ -z "${NONINTERACTIVE}" ]; then
#     echo "  Directory in which non-standard NAMELIST files are prepared"
#     echo $ECHO_N "    [${confdir}]: $ECHO_C"
#     if [ ! -d "$confidir" ]; then
# 	echo ""
# 	echo "  Error: non-standard CONF directory not found."
# 	echo ""
# 	exit 1
#     fi
#else
#    nmldir=$DEFAULT_NMLDIR
#fi
# ls "$nmldir" > /dev/null
# #echo $nmldir

# confpathlist=''
# for conflfiles in `ls "$confdir"/*."${NMLFILE_SUFFIX}" 2> /dev/null`; do
#     if [ -n "$conffiles" ]; then
#  	for confpath in $conffiles; do
#  	    test -f "${confpath}" || continue
#  	    confpathlist=${confpathlist}' '${confpath}
#  	done
#     fi
# done

######################################################################
#== Create directoies and copy some files
#
# Create directories
#
if [ ! -d "$expdir/bin" ]; then
    $INSTALLDIR "${expdir}/bin"
fi

#if [ ! -d "$expdir" ]; then
#    echo $ECHO_N "  Creating \"${expdir}\" ... $ECHO_C"
#    $INSTALLDIR "${expdir}"
#    $INSTALLDIR "${expdir}/bin"
#    $INSTALLDIR "${expdir}/conf"
#    $INSTALLDIR "${expdir}/src"
#    for srcsubdir in $nonstdsrcsubdirnamelist ; do
#	$INSTALLDIR "${expdir}/src/${srcsubdir}"
#    done
#    echo "  done. "
#fi
#
# copy non standard src files
#
# echo ""
# echo ""
# echo "  Copying non-standard source files to \"${expdir}/src\" ... "
# for nonstdsrcsubdirname in $nonstdsrcsubdirnamelist ; do
#     for nonstdsrcfile in `ls ${nonstdsrcdir}/${nonstdsrcsubdirname}/*`; do
#  	test -f "${nonstdsrcfile}" || continue
# 	update_file "${nonstdsrcfile}" "${expdir}/src/${nonstdsrcsubdirname}"
#     done
# done
# echo "  done. "
#
# copy non standard NAMELIST files
#
# echo "  Copying non-standard NAMELIST files to \"${expdir}/nml\" ... "
# for nmlpath in $nmlpathlist ; do
#     update_file "${nmlpath}" "${expdir}/nml"
# done
# echo "  done. "
#
# create Makefiles
#
if [ -f "$expdir/Makefile" ]; then
    backup_oldfile "$expdir/Makefile"
    echo $ECHO_N "  Updating \"$expdir/Makefile\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$expdir/Makefile\" ... $ECHO_C"
fi
create_mk_top "$expdir/Makefile"
echo "  done. "

if [ -f "$expdir/src/Makefile" ]; then
    backup_oldfile "$expdir/src/Makefile"
    echo $ECHO_N "  Updating \"$expdir/src/Makefile\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$expdir/src/Makefile\" ... $ECHO_C"
fi
create_mk_src "$expdir/src/Makefile" "$expdir/src" 
echo "  done. "

if [ -f "$expdir/src/main/Makefile" ]; then
    backup_oldfile "$expdir/src/main/Makefile"
    echo $ECHO_N "  Updating \"$expdir/src/main/Makefile\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$expdir/src/main/Makefile\" ... $ECHO_C"
fi
create_mk_src_main "$expdir/src/main/Makefile" "$expdir/src/main" 
echo "  done. "

for dir in `ls ${expdir}/src`; do
    test -d "${expdir}/src/${dir}" && test ${dir} != 'main' || continue
    if [ -f "$expdir/src/${dir}/Makefile" ]; then
	backup_oldfile "$expdir/src/${dir}/Makefile"
	echo $ECHO_N "  Updating \"$expdir/src/${dir}/Makefile\" ... $ECHO_C"
    else
	echo $ECHO_N "  Creating \"$expdir/src/${dir}/Makefile\" ... $ECHO_C"
    fi
    create_mk_src_subdir "${expdir}/src/${dir}/Makefile" "${expdir}/src/${dir}" 
    echo "  done. "
done
#
# create Config.mk
#
if [ -f "$expdir/Config.mk" ]; then
    backup_oldfile "$expdir/Config.mk"
    echo $ECHO_N "  Updating \"$expdir/Config.mk\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$expdir/Config.mk\" ... $ECHO_C"
fi
create_mk_Configmk "$expdir/Config.mk"
echo "  done. "
#
# create rules.make
#
if [ -f "$expdir/rules.make" ]; then
    backup_oldfile "$expdir/rules.make"
    echo $ECHO_N "  Updating \"$expdir/rules.make\" ... $ECHO_C"
else
    echo $ECHO_N "  Creating \"$expdir/rules.make\" ... $ECHO_C"
fi
${INSTALL} rules.make $expdir/rules.make
echo "  done. "

echo ""
echo "*** Setup of \"${expdir}\" is complete ***"
echo ""
exit 0
