function DCCalConvertToMin1( in_time, in_unit, cal ) result( out_time )
  !
  ! Ǥդλñ (ʬ) äؤñ̤ѴԤޤ. 
  ! 
  ! ֤ñ̤ȤͭʸˤĤƤϰʲ򻲾Ȳ.
  !
  ! dc_calendar_types#UNIT_SEC          :: äñ
  ! dc_calendar_types#UNIT_MIN          :: ʬñ
  ! dc_calendar_types#UNIT_HOUR         :: ֤ñ
  ! dc_calendar_types#UNIT_DAY          :: ñ
  ! 
  ! άǽ *cal* ά줿ˤ, dc_calendar 
  ! ݻ˴ؤѤñ̤ѴԤޤ. 
  ! *cal* άʤˤϤѿꤵ줿ξ
  ! Ѥñ̤ѴԤޤ. 
  !
  ! Convert of unit from arbitrary time units (day, hour, minute, second) 
  ! into sec. 
  !
  ! Valid strings as units of time are follows. 
  ! 
  ! dc_calendar_types#UNIT_SEC          :: Units of second
  ! dc_calendar_types#UNIT_MIN          :: Units of minute
  ! dc_calendar_types#UNIT_HOUR         :: Units of hour
  ! dc_calendar_types#UNIT_DAY          :: Units of day
  !
  ! If an optional argument *cal* is omitted, 
  ! unit is converted with information of a calendar 
  ! that is stored in the "dc_calendar". 
  ! If *cal* is not omitted, unit is converted with information of the variable.
  !
  use dc_calendar_internal, only: default_cal, default_cal_set, &
    & dccaltype_str, dccaldate_str2usym
  use dc_calendar_types, only: DC_CAL, &
    & UNIT_SYMBOL_YEAR, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_DAY, &
    & UNIT_SYMBOL_HOUR, UNIT_SYMBOL_MIN, UNIT_SYMBOL_SEC
  use dc_calendar_generic, only: DCCalConvertByUnit
  use dc_error, only: StoreError, DC_NOERR, DC_EBADUNIT, DC_ENOTINIT
  use dc_message, only: MessageNotify
  use dc_trace, only: BeginSub, EndSub
  use dc_types, only: DP, TOKEN, STRING
  implicit none
  real(DP):: out_time
                              ! Ѵλ֤ο. 
                              ! 
                              ! Numerical value of time after conversion. 

  real(DP), intent(in):: in_time
                              ! Ѵλ֤ο. 
                              ! 
                              ! Numerical value of time before conversion. 
  character(*), intent(in):: in_unit
                              ! Ѵλ֤ñ. 
                              ! 
                              ! Units of time before conversion. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 

  ! ѿ
  ! Work variables
  !
  type(DC_CAL), pointer:: calp =>null()
  integer:: in_unit_sym, out_unit_sym
!!$  integer:: stat
!!$  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalConvertToMin1'
continue
!!$  call BeginSub( subname )
!!$  stat = DC_NOERR
!!$  cause_c = ''

  out_time = -1.0

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  if ( .not. calp % initialized ) then
    call MessageNotify('W', subname, '"cal" is not initialized. <-1> is returned.' )
!!$    stat = DC_ENOTINIT
!!$    cause_c = 'DC_CAL'
    goto 999
  end if

  ! ñ̤β
  ! Parse units
  !
  in_unit_sym  = dccaldate_str2usym( in_unit )
  out_unit_sym = UNIT_SYMBOL_MIN

  ! ͤѴ
  ! Convert a value
  !
  out_time = DCCalConvertByUnit( in_time, in_unit_sym, out_unit_sym, cal )

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( calp )
!!$  call StoreError( stat, subname, err, cause_c )
!!$  call EndSub( subname )
end function DCCalConvertToMin1

!---------------------------------------------------------------------

function DCCalConvertToMin2( in_time, in_unit, cal ) result( out_time )
  !
  ! Ǥդλñ (ʬ) äؤñ̤ѴԤޤ. 
  ! 
  ! ֤ñ̤ȤͭѿˤĤƤϰʲ򻲾Ȳ. 
  ! ñ̤ȤͤľͿ뤳ȤϤ, ʲѿ
  ! ͿƤ. 
  !
  ! dc_calendar_types#UNIT_SYMBOL_SEC          :: äñ
  ! dc_calendar_types#UNIT_SYMBOL_MIN          :: ʬñ
  ! dc_calendar_types#UNIT_SYMBOL_HOUR         :: ֤ñ
  ! dc_calendar_types#UNIT_SYMBOL_DAY          :: ñ
  ! 
  ! άǽ *cal* ά줿ˤ, dc_calendar 
  ! ݻ˴ؤѤñ̤ѴԤޤ. 
  ! *cal* άʤˤϤѿꤵ줿ξ
  ! Ѥñ̤ѴԤޤ. 
  !
  ! Convert of unit from arbitrary time units (day, hour, minute, second) 
  ! into sec. 
  !
  ! Valid integer variables as units of time are follows. 
  ! Do not specify integer directly, but specify following variables. 
  ! 
  ! dc_calendar_types#UNIT_SYMBOL_SEC          :: Units of second
  ! dc_calendar_types#UNIT_SYMBOL_MIN          :: Units of minute
  ! dc_calendar_types#UNIT_SYMBOL_HOUR         :: Units of hour
  ! dc_calendar_types#UNIT_SYMBOL_DAY          :: Units of day
  !
  ! If an optional argument *cal* is omitted, 
  ! unit is converted with information of a calendar 
  ! that is stored in the "dc_calendar". 
  ! If *cal* is not omitted, unit is converted with information of the variable.
  !
  use dc_calendar_internal, only: default_cal, default_cal_set, &
    & dccaltype_str, dccaldate_str2usym
  use dc_calendar_generic, only: DCCalConvertByUnit
  use dc_calendar_types, only: DC_CAL, &
    & UNIT_SYMBOL_YEAR, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_DAY, &
    & UNIT_SYMBOL_HOUR, UNIT_SYMBOL_MIN, UNIT_SYMBOL_SEC
  use dc_error, only: StoreError, DC_NOERR, DC_EBADUNIT, DC_ENOTINIT
  use dc_message, only: MessageNotify
  use dc_trace, only: BeginSub, EndSub
  use dc_types, only: DP, TOKEN, STRING
  implicit none
  real(DP):: out_time
                              ! Ѵλ֤ο. 
                              ! 
                              ! Numerical value of time after conversion. 
  real(DP), intent(in):: in_time
                              ! Ѵλ֤ο. 
                              ! 
                              ! Numerical value of time before conversion. 
  integer, intent(in):: in_unit
                              ! Ѵλ֤ñ. 
                              ! 
                              ! Units of time before conversion. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 

  ! ѿ
  ! Work variables
  !
  type(DC_CAL), pointer:: calp =>null()
  integer:: out_unit
                              ! Ѵλ֤ñ. 
                              ! 
                              ! Units of time after conversion. 

!!$  integer:: stat
!!$  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalConvertToMin2'
continue
!!$  call BeginSub( subname )
!!$  stat = DC_NOERR
!!$  cause_c = ''

  out_time = -1.0

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  if ( .not. calp % initialized ) then
    call MessageNotify('W', subname, '"cal" is not initialized. <-1> is returned.' )
!!$    stat = DC_ENOTINIT
!!$    cause_c = 'DC_CAL'
    goto 999
  end if

  ! ñ̤β
  ! Parse units
  !
  out_unit = UNIT_SYMBOL_MIN

  ! ͤѴ
  ! Convert a value
  !
  out_time = DCCalConvertByUnit( in_time, in_unit, out_unit, cal )

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( calp )
!!$  call StoreError( stat, subname, err, cause_c )
!!$  call EndSub( subname )
end function DCCalConvertToMin2
