#
# vstl02.rb
#
# $Id: vstl02.rb,v 1.1.1.1 2011-02-23 07:21:28 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


IX = 3
IY = 3
NN = 4

x = NArray[1, 3,-1, 2,-4, 0, 2, 1, 3, 2, 1, 0]
y = NArray[0, 1, 0, 1,-2, 1, 3, 0, 2, 1,-1, 0]
x.reshape!(IX, NN)
y.reshape!(IY, NN)

fmt1 = " INPUT(%s) = " + "%6.1f"*3 + "\n"
fmt2 = "%6.1f"*3 + ("\n" + " "*12 + "%6.1f"*3)*2

print " *** TEST FOR VS2INT / VS2DIN / VS2OUT\n"
wz2, nw2 = DCL::vs2int(IX, IY)
for j in 0..NN-1
  printf fmt1, "X", x[0,j], x[1,j], x[2,j]
  printf fmt1, "Y", y[0,j], y[1,j], y[2,j]
  wz2, nw2 = DCL::vs2din(wz2, nw2, x[true,j], y[true,j])
end
wz2 = DCL::vs2out(wz2, nw2)
printf " AVE. (X) = %s\n", fmt2 % wz2.to_a.flatten[0,IX*IY]
printf " AVE. (Y) = %s\n", fmt2 % wz2.to_a.flatten[IX*IY,IX*IY]
printf " VAR. (X) = %s\n", fmt2 % wz2.to_a.flatten[IX*IY*2,IX*IY]
printf " VAR. (Y) = %s\n", fmt2 % wz2.to_a.flatten[IX*IY*3,IX*IY]
printf " COV(X,Y) = %s\n", fmt2 % wz2.to_a.flatten[IX*IY*4,IX*IY]
