/*
 * $Id: p_header,v 1.2 2011-02-23 17:47:10 koshiro Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_uysaxz(obj, cside, roffy)
    VALUE obj, cside, roffy;
{
    char *i_cside;
    real i_roffy;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(roffy) != T_FLOAT) {
      roffy = rb_funcall(roffy, rb_intern("to_f"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_roffy = (real)NUM2DBL(roffy);


    uysaxz_(i_cside, &i_roffy, (ftnlen)strlen(i_cside));

    return Qnil;

}

static VALUE
dcl_uysaxs(obj, cside)
    VALUE obj, cside;
{
    char *i_cside;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }

    i_cside = StringValuePtr(cside);


    uysaxs_(i_cside, (ftnlen)strlen(i_cside));

    return Qnil;

}

static VALUE
dcl_uypaxs(obj, cside, islct)
    VALUE obj, cside, islct;
{
    char *i_cside;
    integer i_islct;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if ((TYPE(islct) != T_BIGNUM) || (TYPE(islct) != T_FIXNUM)) {
      islct = rb_funcall(islct, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_islct = NUM2INT(islct);


    uypaxs_(i_cside, &i_islct, (ftnlen)strlen(i_cside));

    return Qnil;

}

static VALUE
dcl_uyptmk(obj, cside, islct, uy, n)
    VALUE obj, cside, islct, uy, n;
{
    char *i_cside;
    integer i_islct;
    real *i_uy;
    integer i_n;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if ((TYPE(islct) != T_BIGNUM) || (TYPE(islct) != T_FIXNUM)) {
      islct = rb_funcall(islct, rb_intern("to_i"), 0);
    }
    if (TYPE(uy) == T_FLOAT) {
      uy = rb_Array(uy);
    }
    /* if ((TYPE(uy) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_islct = NUM2INT(islct);
    i_n = NUM2INT(n);
    i_uy = dcl_obj2crealary(uy);


    uyptmk_(i_cside, &i_islct, i_uy, &i_n, (ftnlen)strlen(i_cside));

    dcl_freecrealary(i_uy);

    return Qnil;

}

static VALUE
dcl_uyplbl(obj, cside, islct, uy, ch, nc, n)
    VALUE obj, cside, islct, uy, ch, nc, n;
{
    char *i_cside;
    integer i_islct;
    real *i_uy;
    char *i_ch;
    integer i_nc;
    integer i_n;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if ((TYPE(islct) != T_BIGNUM) || (TYPE(islct) != T_FIXNUM)) {
      islct = rb_funcall(islct, rb_intern("to_i"), 0);
    }
    if (TYPE(uy) == T_FLOAT) {
      uy = rb_Array(uy);
    }
    /* if ((TYPE(uy) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(ch) == T_STRING) {
      ch = rb_Array(ch);
    }
    if (TYPE(ch) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(nc) != T_BIGNUM) || (TYPE(nc) != T_FIXNUM)) {
      nc = rb_funcall(nc, rb_intern("to_i"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_islct = NUM2INT(islct);
    i_nc = NUM2INT(nc);
    i_n = NUM2INT(n);
    i_uy = dcl_obj2crealary(uy);
    i_ch = dcl_obj2ccharary(ch, (i_n*DFLT_SIZE), DFLT_SIZE);


    uyplbl_(i_cside, &i_islct, i_uy, i_ch, &i_nc, &i_n, (ftnlen)strlen(i_cside), (ftnlen)DFLT_SIZE);

    dcl_freecrealary(i_uy);
    dcl_freeccharary(i_ch);

    return Qnil;

}

static VALUE
dcl_uypnum(obj, cside, islct, uy, n)
    VALUE obj, cside, islct, uy, n;
{
    char *i_cside;
    integer i_islct;
    real *i_uy;
    integer i_n;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if ((TYPE(islct) != T_BIGNUM) || (TYPE(islct) != T_FIXNUM)) {
      islct = rb_funcall(islct, rb_intern("to_i"), 0);
    }
    if (TYPE(uy) == T_FLOAT) {
      uy = rb_Array(uy);
    }
    /* if ((TYPE(uy) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_islct = NUM2INT(islct);
    i_n = NUM2INT(n);
    i_uy = dcl_obj2crealary(uy);


    uypnum_(i_cside, &i_islct, i_uy, &i_n, (ftnlen)strlen(i_cside));

    dcl_freecrealary(i_uy);

    return Qnil;

}

static VALUE
dcl_uypttl(obj, cside, islct, cttl, px)
    VALUE obj, cside, islct, cttl, px;
{
    char *i_cside;
    integer i_islct;
    char *i_cttl;
    real i_px;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if ((TYPE(islct) != T_BIGNUM) || (TYPE(islct) != T_FIXNUM)) {
      islct = rb_funcall(islct, rb_intern("to_i"), 0);
    }
    if (TYPE(cttl) != T_STRING) {
      cttl = rb_funcall(cttl, rb_intern("to_str"), 0);
    }
    if (TYPE(px) != T_FLOAT) {
      px = rb_funcall(px, rb_intern("to_f"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_islct = NUM2INT(islct);
    i_cttl = StringValuePtr(cttl);
    i_px = (real)NUM2DBL(px);


    uypttl_(i_cside, &i_islct, i_cttl, &i_px, (ftnlen)strlen(i_cside), (ftnlen)strlen(i_cttl));

    return Qnil;

}

static VALUE
dcl_uyaxlb(obj, cside, uy1, n1, uy2, ch, nc, n2)
    VALUE obj, cside, uy1, n1, uy2, ch, nc, n2;
{
    char *i_cside;
    real *i_uy1;
    integer i_n1;
    real *i_uy2;
    char *i_ch;
    integer i_nc;
    integer i_n2;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(uy1) == T_FLOAT) {
      uy1 = rb_Array(uy1);
    }
    /* if ((TYPE(uy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n1) != T_BIGNUM) || (TYPE(n1) != T_FIXNUM)) {
      n1 = rb_funcall(n1, rb_intern("to_i"), 0);
    }
    if (TYPE(uy2) == T_FLOAT) {
      uy2 = rb_Array(uy2);
    }
    /* if ((TYPE(uy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(ch) == T_STRING) {
      ch = rb_Array(ch);
    }
    if (TYPE(ch) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(nc) != T_BIGNUM) || (TYPE(nc) != T_FIXNUM)) {
      nc = rb_funcall(nc, rb_intern("to_i"), 0);
    }
    if ((TYPE(n2) != T_BIGNUM) || (TYPE(n2) != T_FIXNUM)) {
      n2 = rb_funcall(n2, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_n1 = NUM2INT(n1);
    i_nc = NUM2INT(nc);
    i_n2 = NUM2INT(n2);
    i_uy1 = dcl_obj2crealary(uy1);
    i_uy2 = dcl_obj2crealary(uy2);
    i_ch = dcl_obj2ccharary(ch, (i_n2*DFLT_SIZE), DFLT_SIZE);


    uyaxlb_(i_cside, i_uy1, &i_n1, i_uy2, i_ch, &i_nc, &i_n2, (ftnlen)strlen(i_cside), (ftnlen)DFLT_SIZE);

    dcl_freecrealary(i_uy1);
    dcl_freecrealary(i_uy2);
    dcl_freeccharary(i_ch);

    return Qnil;

}

static VALUE
dcl_uyaxnm(obj, cside, uy1, n1, uy2, n2)
    VALUE obj, cside, uy1, n1, uy2, n2;
{
    char *i_cside;
    real *i_uy1;
    integer i_n1;
    real *i_uy2;
    integer i_n2;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(uy1) == T_FLOAT) {
      uy1 = rb_Array(uy1);
    }
    /* if ((TYPE(uy1) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy1, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n1) != T_BIGNUM) || (TYPE(n1) != T_FIXNUM)) {
      n1 = rb_funcall(n1, rb_intern("to_i"), 0);
    }
    if (TYPE(uy2) == T_FLOAT) {
      uy2 = rb_Array(uy2);
    }
    /* if ((TYPE(uy2) != T_ARRAY) && 
           (rb_obj_is_kind_of(uy2, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n2) != T_BIGNUM) || (TYPE(n2) != T_FIXNUM)) {
      n2 = rb_funcall(n2, rb_intern("to_i"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_n1 = NUM2INT(n1);
    i_n2 = NUM2INT(n2);
    i_uy1 = dcl_obj2crealary(uy1);
    i_uy2 = dcl_obj2crealary(uy2);


    uyaxnm_(i_cside, i_uy1, &i_n1, i_uy2, &i_n2, (ftnlen)strlen(i_cside));

    dcl_freecrealary(i_uy1);
    dcl_freecrealary(i_uy2);

    return Qnil;

}

static VALUE
dcl_uyaxdv(obj, cside, dy1, dy2)
    VALUE obj, cside, dy1, dy2;
{
    char *i_cside;
    real i_dy1;
    real i_dy2;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(dy1) != T_FLOAT) {
      dy1 = rb_funcall(dy1, rb_intern("to_f"), 0);
    }
    if (TYPE(dy2) != T_FLOAT) {
      dy2 = rb_funcall(dy2, rb_intern("to_f"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_dy1 = (real)NUM2DBL(dy1);
    i_dy2 = (real)NUM2DBL(dy2);


    uyaxdv_(i_cside, &i_dy1, &i_dy2, (ftnlen)strlen(i_cside));

    return Qnil;

}

static VALUE
dcl_uymttl(obj, cside, cttl, px)
    VALUE obj, cside, cttl, px;
{
    char *i_cside;
    char *i_cttl;
    real i_px;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(cttl) != T_STRING) {
      cttl = rb_funcall(cttl, rb_intern("to_str"), 0);
    }
    if (TYPE(px) != T_FLOAT) {
      px = rb_funcall(px, rb_intern("to_f"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_cttl = StringValuePtr(cttl);
    i_px = (real)NUM2DBL(px);


    uymttl_(i_cside, i_cttl, &i_px, (ftnlen)strlen(i_cside), (ftnlen)strlen(i_cttl));

    return Qnil;

}

static VALUE
dcl_uysttl(obj, cside, cttl, px)
    VALUE obj, cside, cttl, px;
{
    char *i_cside;
    char *i_cttl;
    real i_px;

    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(cttl) != T_STRING) {
      cttl = rb_funcall(cttl, rb_intern("to_str"), 0);
    }
    if (TYPE(px) != T_FLOAT) {
      px = rb_funcall(px, rb_intern("to_f"), 0);
    }

    i_cside = StringValuePtr(cside);
    i_cttl = StringValuePtr(cttl);
    i_px = (real)NUM2DBL(px);


    uysttl_(i_cside, i_cttl, &i_px, (ftnlen)strlen(i_cside), (ftnlen)strlen(i_cttl));

    return Qnil;

}

static VALUE
dcl_uysfmt(obj, cfmt)
    VALUE obj, cfmt;
{
    char *i_cfmt;

    if (TYPE(cfmt) != T_STRING) {
      cfmt = rb_funcall(cfmt, rb_intern("to_str"), 0);
    }

    i_cfmt = StringValuePtr(cfmt);


    uysfmt_(i_cfmt, (ftnlen)strlen(i_cfmt));

    return Qnil;

}

static VALUE
dcl_uyqfmt(obj)
    VALUE obj;
{
    char *o_cfmt;
    VALUE cfmt;

    o_cfmt= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cfmt, '\0', DFLT_SIZE+1);

    uyqfmt_(o_cfmt, (ftnlen)DFLT_SIZE);

    cfmt = rb_str_new2(o_cfmt);


    return cfmt;

}
void
init_grph2_uypack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "uysaxz", dcl_uysaxz, 2);
    rb_define_module_function(mDCL, "uysaxs", dcl_uysaxs, 1);
    rb_define_module_function(mDCL, "uypaxs", dcl_uypaxs, 2);
    rb_define_module_function(mDCL, "uyptmk", dcl_uyptmk, 4);
    rb_define_module_function(mDCL, "uyplbl", dcl_uyplbl, 6);
    rb_define_module_function(mDCL, "uypnum", dcl_uypnum, 4);
    rb_define_module_function(mDCL, "uypttl", dcl_uypttl, 4);
    rb_define_module_function(mDCL, "uyaxlb", dcl_uyaxlb, 7);
    rb_define_module_function(mDCL, "uyaxnm", dcl_uyaxnm, 5);
    rb_define_module_function(mDCL, "uyaxdv", dcl_uyaxdv, 3);
    rb_define_module_function(mDCL, "uymttl", dcl_uymttl, 3);
    rb_define_module_function(mDCL, "uysttl", dcl_uysttl, 3);
    rb_define_module_function(mDCL, "uysfmt", dcl_uysfmt, 1);
    rb_define_module_function(mDCL, "uyqfmt", dcl_uyqfmt, 0);
}
