#
# scpkt3.rb
#
# $Id: scpkt3.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 73
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90

p1 = NArray.sfloat(nx*ny)
p2 = NArray.sfloat(nx*ny)

#-- data ---
i = 0
File.foreach("t810630.dat") do |line|
  line.split(" ").each do |data|
    p1[i] = data.to_f
    i += 1
  end
end
i = 0
File.foreach("t811231.dat") do |line|
  line.split(" ").each do |data|
    p2[i] = data.to_f
    i += 1
  end
end
p1.reshape!(nx, ny)
p2.reshape!(nx, ny)

190.step(245, 5) do |r|
  amin=r
  amax=r+5
#       IDX=(R-180)*1.4*1000+999
  idx=((r-170)*1.25).to_i*1000+999
  DCL::uestlv(amin, amax, idx)
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sglset('LSOFTF', false)
DCL::umlset('LGRIDMJ', false)
DCL::umrset('DGRIDMN', 30.0)
DCL::umiset('ITYPEMN', 1)
DCL::umiset('ITYPEOUT', 1)
DCL::sgfrm

DCL::sglset('L2TO3', true)
#     CALL SCSEYE(-1.0, -1.5,  2.0 )
DCL::scsobj(0.5, 0.5, 0.0)
DCL::scspln(1, 2, -0.3)
DCL::scsprj

DCL::sgssim(0.12, 0.0, 0.0)
DCL::sgsmpl(180.0, 90.0, 0.0)
DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgstxy(-180.0, 180.0, -90.0, 90.0)
DCL::sgstrn(DCL::isgtrc('MER'))
DCL::sgstrf

DCL::sglset('LCLIP', true)
DCL::slpwwr(1)

DCL::uetone(p1)
DCL::umpmap('coast_world')
DCL::umpglb
DCL::slpvpr(1)

DCL::sglset('LCLIP', false)
DCL::sgtxzv(0.5, 0.95, 'Temp. : 10 hPa : Jun 30, 1981', 0.025, 0, 0, 3)

DCL::scspln(1, 2, 0.4)
#     CALL SGRSET( 'YOFF3', -0.25 )
DCL::scsprj

DCL::sglset('LCLIP', true)
DCL::slpwwr(1)

DCL::uetone(p2)
DCL::umpmap('coast_world')
DCL::umpglb
DCL::slpvpr(1)

DCL::sglset('LCLIP', false)
DCL::sgtxzv(0.5, 0.95, 'Temp. : 10 hPa : Dec 31, 1981', 0.025, 0, 0, 3)

DCL::sgcls

