/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_vs1int(obj, ix)
    VALUE obj, ix;
{
    real *o_wz;
    integer *o_nw;
    integer i_ix;
    VALUE wz;
    VALUE nw;

    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }

    i_ix = NUM2INT(ix);

    o_wz= ALLOCA_N(real, (i_ix*2));
    o_nw= ALLOCA_N(integer, (i_ix));

    vs1int_(o_wz, o_nw, &i_ix);

    {int array_shape[2] = {i_ix, 2};
     wz = dcl_crealary2obj(o_wz, (i_ix*2), 2, array_shape);
    }
    {int array_shape[1] = {i_ix};
     nw = dcl_cintegerary2obj(o_nw, (i_ix), 1, array_shape);
    }


    return rb_ary_new3(2, wz, nw);

}

static VALUE
dcl_vs1din(obj, wz, nw, ix, x)
    VALUE obj, wz, nw, ix, x;
{
    real *io_wz;
    integer *io_nw;
    integer i_ix;
    real *i_x;

    if (TYPE(wz) == T_FLOAT) {
      wz = rb_Array(wz);
    }
    /* if ((TYPE(wz) != T_ARRAY) && 
           (rb_obj_is_kind_of(wz, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nw) == T_BIGNUM) || (TYPE(nw) == T_FIXNUM)) {
      nw = rb_Array(nw);
    }
    /* if ((TYPE(nw) != T_ARRAY) && 
           (rb_obj_is_kind_of(nw, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if (TYPE(x) == T_FLOAT) {
      x = rb_Array(x);
    }
    /* if ((TYPE(x) != T_ARRAY) && 
           (rb_obj_is_kind_of(x, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_ix = NUM2INT(ix);
    io_wz = dcl_obj2crealary(wz);
    io_nw = dcl_obj2cintegerary(nw);
    i_x = dcl_obj2crealary(x);


    vs1din_(io_wz, io_nw, &i_ix, i_x);

    {int array_shape[2] = {i_ix, 2};
     wz = dcl_crealary2obj(io_wz, (i_ix*2), 2, array_shape);
    }
    {int array_shape[1] = {i_ix};
     nw = dcl_cintegerary2obj(io_nw, (i_ix), 1, array_shape);
    }

    dcl_freecrealary(io_wz);
    dcl_freecintegerary(io_nw);
    dcl_freecrealary(i_x);

    return rb_ary_new3(2, wz, nw);

}

static VALUE
dcl_vs1out(obj, wz, nw, ix)
    VALUE obj, wz, nw, ix;
{
    real *io_wz;
    integer *i_nw;
    integer i_ix;

    if (TYPE(wz) == T_FLOAT) {
      wz = rb_Array(wz);
    }
    /* if ((TYPE(wz) != T_ARRAY) && 
           (rb_obj_is_kind_of(wz, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nw) == T_BIGNUM) || (TYPE(nw) == T_FIXNUM)) {
      nw = rb_Array(nw);
    }
    /* if ((TYPE(nw) != T_ARRAY) && 
           (rb_obj_is_kind_of(nw, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }

    i_ix = NUM2INT(ix);
    io_wz = dcl_obj2crealary(wz);
    i_nw = dcl_obj2cintegerary(nw);


    vs1out_(io_wz, i_nw, &i_ix);

    {int array_shape[2] = {i_ix, 2};
     wz = dcl_crealary2obj(io_wz, (i_ix*2), 2, array_shape);
    }

    dcl_freecrealary(io_wz);
    dcl_freecintegerary(i_nw);

    return wz;

}

static VALUE
dcl_vs2int(obj, ix, iy)
    VALUE obj, ix, iy;
{
    real *o_wz;
    integer *o_nw;
    integer i_ix;
    integer i_iy;
    VALUE wz;
    VALUE nw;

    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }

    i_ix = NUM2INT(ix);
    i_iy = NUM2INT(iy);

    o_wz= ALLOCA_N(real, (i_ix*i_iy*5));
    o_nw= ALLOCA_N(integer, (i_ix*i_iy));

    vs2int_(o_wz, o_nw, &i_ix, &i_iy);

    {int array_shape[3] = {i_ix, i_iy, 5};
     wz = dcl_crealary2obj(o_wz, (i_ix*i_iy*5), 3, array_shape);
    }
    {int array_shape[2] = {i_ix, i_iy};
     nw = dcl_cintegerary2obj(o_nw, (i_ix*i_iy), 2, array_shape);
    }


    return rb_ary_new3(2, wz, nw);

}

static VALUE
dcl_vs2din(obj, wz, nw, ix, iy, x, y)
    VALUE obj, wz, nw, ix, iy, x, y;
{
    real *io_wz;
    integer *io_nw;
    integer i_ix;
    integer i_iy;
    real *i_x;
    real *i_y;

    if (TYPE(wz) == T_FLOAT) {
      wz = rb_Array(wz);
    }
    /* if ((TYPE(wz) != T_ARRAY) && 
           (rb_obj_is_kind_of(wz, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nw) == T_BIGNUM) || (TYPE(nw) == T_FIXNUM)) {
      nw = rb_Array(nw);
    }
    /* if ((TYPE(nw) != T_ARRAY) && 
           (rb_obj_is_kind_of(nw, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if (TYPE(x) == T_FLOAT) {
      x = rb_Array(x);
    }
    /* if ((TYPE(x) != T_ARRAY) && 
           (rb_obj_is_kind_of(x, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(y) == T_FLOAT) {
      y = rb_Array(y);
    }
    /* if ((TYPE(y) != T_ARRAY) && 
           (rb_obj_is_kind_of(y, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_ix = NUM2INT(ix);
    i_iy = NUM2INT(iy);
    io_wz = dcl_obj2crealary(wz);
    io_nw = dcl_obj2cintegerary(nw);
    i_x = dcl_obj2crealary(x);
    i_y = dcl_obj2crealary(y);


    vs2din_(io_wz, io_nw, &i_ix, &i_iy, i_x, i_y);

    {int array_shape[3] = {i_ix, i_iy, 5};
     wz = dcl_crealary2obj(io_wz, (i_ix*i_iy*5), 3, array_shape);
    }
    {int array_shape[2] = {i_ix, i_iy};
     nw = dcl_cintegerary2obj(io_nw, (i_ix*i_iy), 2, array_shape);
    }

    dcl_freecrealary(io_wz);
    dcl_freecintegerary(io_nw);
    dcl_freecrealary(i_x);
    dcl_freecrealary(i_y);

    return rb_ary_new3(2, wz, nw);

}

static VALUE
dcl_vs2out(obj, wz, nw, ix, iy)
    VALUE obj, wz, nw, ix, iy;
{
    real *io_wz;
    integer *i_nw;
    integer i_ix;
    integer i_iy;

    if (TYPE(wz) == T_FLOAT) {
      wz = rb_Array(wz);
    }
    /* if ((TYPE(wz) != T_ARRAY) && 
           (rb_obj_is_kind_of(wz, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(nw) == T_BIGNUM) || (TYPE(nw) == T_FIXNUM)) {
      nw = rb_Array(nw);
    }
    /* if ((TYPE(nw) != T_ARRAY) && 
           (rb_obj_is_kind_of(nw, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }

    i_ix = NUM2INT(ix);
    i_iy = NUM2INT(iy);
    io_wz = dcl_obj2crealary(wz);
    i_nw = dcl_obj2cintegerary(nw);


    vs2out_(io_wz, i_nw, &i_ix, &i_iy);

    {int array_shape[3] = {i_ix, i_iy, 5};
     wz = dcl_crealary2obj(io_wz, (i_ix*i_iy*5), 3, array_shape);
    }

    dcl_freecrealary(io_wz);
    dcl_freecintegerary(i_nw);

    return wz;

}
void
init_math2_vstlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "vs1int", dcl_vs1int, 1);
    rb_define_module_function(mDCL, "vs1din", dcl_vs1din, 4);
    rb_define_module_function(mDCL, "vs1out", dcl_vs1out, 3);
    rb_define_module_function(mDCL, "vs2int", dcl_vs2int, 2);
    rb_define_module_function(mDCL, "vs2din", dcl_vs2din, 6);
    rb_define_module_function(mDCL, "vs2out", dcl_vs2out, 4);
}
