/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_date12(obj, idate)
    VALUE obj, idate;
{
    integer i_idate;
    integer o_iy;
    integer o_itd;
    VALUE iy;
    VALUE itd;

    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }

    i_idate = NUM2INT(idate);


    date12_(&i_idate, &o_iy, &o_itd);

    iy = INT2NUM(o_iy);
    itd = INT2NUM(o_itd);


    return rb_ary_new3(2, iy, itd);

}

static VALUE
dcl_date13(obj, idate)
    VALUE obj, idate;
{
    integer i_idate;
    integer o_iy;
    integer o_im;
    integer o_id;
    VALUE iy;
    VALUE im;
    VALUE id;

    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }

    i_idate = NUM2INT(idate);


    date13_(&i_idate, &o_iy, &o_im, &o_id);

    iy = INT2NUM(o_iy);
    im = INT2NUM(o_im);
    id = INT2NUM(o_id);


    return rb_ary_new3(3, iy, im, id);

}

static VALUE
dcl_date21(obj, iy, itd)
    VALUE obj, iy, itd;
{
    integer o_idate;
    integer i_iy;
    integer i_itd;
    VALUE idate;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);


    date21_(&o_idate, &i_iy, &i_itd);

    idate = INT2NUM(o_idate);


    return idate;

}

static VALUE
dcl_date23(obj, iy, itd)
    VALUE obj, iy, itd;
{
    integer io_iy;
    integer o_im;
    integer o_id;
    integer i_itd;
    VALUE im;
    VALUE id;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }

    io_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);


    date23_(&io_iy, &o_im, &o_id, &i_itd);

    iy = INT2NUM(io_iy);
    im = INT2NUM(o_im);
    id = INT2NUM(o_id);


    return rb_ary_new3(3, iy, im, id);

}

static VALUE
dcl_date31(obj, iy, im, id)
    VALUE obj, iy, im, id;
{
    integer o_idate;
    integer i_iy;
    integer i_im;
    integer i_id;
    VALUE idate;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);


    date31_(&o_idate, &i_iy, &i_im, &i_id);

    idate = INT2NUM(o_idate);


    return idate;

}

static VALUE
dcl_date32(obj, iy, im, id)
    VALUE obj, iy, im, id;
{
    integer io_iy;
    integer i_im;
    integer i_id;
    integer o_itd;
    VALUE itd;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    io_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);


    date32_(&io_iy, &i_im, &i_id, &o_itd);

    iy = INT2NUM(io_iy);
    itd = INT2NUM(o_itd);


    return rb_ary_new3(2, iy, itd);

}

static VALUE
dcl_datef1(obj, n, idate)
    VALUE obj, n, idate;
{
    integer i_n;
    integer i_idate;
    integer o_ndate;
    VALUE ndate;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_idate = NUM2INT(idate);


    datef1_(&i_n, &i_idate, &o_ndate);

    ndate = INT2NUM(o_ndate);


    return ndate;

}

static VALUE
dcl_datef2(obj, n, iy, itd)
    VALUE obj, n, iy, itd;
{
    integer i_n;
    integer i_iy;
    integer i_itd;
    integer o_ny;
    integer o_ntd;
    VALUE ny;
    VALUE ntd;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);


    datef2_(&i_n, &i_iy, &i_itd, &o_ny, &o_ntd);

    ny = INT2NUM(o_ny);
    ntd = INT2NUM(o_ntd);


    return rb_ary_new3(2, ny, ntd);

}

static VALUE
dcl_datef3(obj, n, iy, im, id)
    VALUE obj, n, iy, im, id;
{
    integer i_n;
    integer i_iy;
    integer i_im;
    integer i_id;
    integer o_ny;
    integer o_nm;
    integer o_nd;
    VALUE ny;
    VALUE nm;
    VALUE nd;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);


    datef3_(&i_n, &i_iy, &i_im, &i_id, &o_ny, &o_nm, &o_nd);

    ny = INT2NUM(o_ny);
    nm = INT2NUM(o_nm);
    nd = INT2NUM(o_nd);


    return rb_ary_new3(3, ny, nm, nd);

}

static VALUE
dcl_dateg1(obj, idate, ndate)
    VALUE obj, idate, ndate;
{
    integer o_n;
    integer i_idate;
    integer i_ndate;
    VALUE n;

    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }
    if ((TYPE(ndate) != T_BIGNUM) || (TYPE(ndate) != T_FIXNUM)) {
      ndate = rb_funcall(ndate, rb_intern("to_i"), 0);
    }

    i_idate = NUM2INT(idate);
    i_ndate = NUM2INT(ndate);


    dateg1_(&o_n, &i_idate, &i_ndate);

    n = INT2NUM(o_n);


    return n;

}

static VALUE
dcl_dateg2(obj, iy, itd, ny, ntd)
    VALUE obj, iy, itd, ny, ntd;
{
    integer o_n;
    integer i_iy;
    integer i_itd;
    integer i_ny;
    integer i_ntd;
    VALUE n;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }
    if ((TYPE(ntd) != T_BIGNUM) || (TYPE(ntd) != T_FIXNUM)) {
      ntd = rb_funcall(ntd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);
    i_ny = NUM2INT(ny);
    i_ntd = NUM2INT(ntd);


    dateg2_(&o_n, &i_iy, &i_itd, &i_ny, &i_ntd);

    n = INT2NUM(o_n);


    return n;

}

static VALUE
dcl_dateg3(obj, iy, im, id, ny, nm, nd)
    VALUE obj, iy, im, id, ny, nm, nd;
{
    integer o_n;
    integer i_iy;
    integer i_im;
    integer i_id;
    integer i_ny;
    integer i_nm;
    integer i_nd;
    VALUE n;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }
    if ((TYPE(nm) != T_BIGNUM) || (TYPE(nm) != T_FIXNUM)) {
      nm = rb_funcall(nm, rb_intern("to_i"), 0);
    }
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);
    i_ny = NUM2INT(ny);
    i_nm = NUM2INT(nm);
    i_nd = NUM2INT(nd);


    dateg3_(&o_n, &i_iy, &i_im, &i_id, &i_ny, &i_nm, &i_nd);

    n = INT2NUM(o_n);


    return n;

}

static VALUE
dcl_ndate1(obj, idate, ndate)
    VALUE obj, idate, ndate;
{
    integer i_idate;
    integer i_ndate;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }
    if ((TYPE(ndate) != T_BIGNUM) || (TYPE(ndate) != T_FIXNUM)) {
      ndate = rb_funcall(ndate, rb_intern("to_i"), 0);
    }

    i_idate = NUM2INT(idate);
    i_ndate = NUM2INT(ndate);


    o_rtn_val = ndate1_(&i_idate, &i_ndate);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_ndate2(obj, iy, itd, ny, ntd)
    VALUE obj, iy, itd, ny, ntd;
{
    integer i_iy;
    integer i_itd;
    integer i_ny;
    integer i_ntd;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }
    if ((TYPE(ntd) != T_BIGNUM) || (TYPE(ntd) != T_FIXNUM)) {
      ntd = rb_funcall(ntd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);
    i_ny = NUM2INT(ny);
    i_ntd = NUM2INT(ntd);


    o_rtn_val = ndate2_(&i_iy, &i_itd, &i_ny, &i_ntd);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_ndate3(obj, iy, im, id, ny, nm, nd)
    VALUE obj, iy, im, id, ny, nm, nd;
{
    integer i_iy;
    integer i_im;
    integer i_id;
    integer i_ny;
    integer i_nm;
    integer i_nd;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }
    if ((TYPE(nm) != T_BIGNUM) || (TYPE(nm) != T_FIXNUM)) {
      nm = rb_funcall(nm, rb_intern("to_i"), 0);
    }
    if ((TYPE(nd) != T_BIGNUM) || (TYPE(nd) != T_FIXNUM)) {
      nd = rb_funcall(nd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);
    i_ny = NUM2INT(ny);
    i_nm = NUM2INT(nm);
    i_nd = NUM2INT(nd);


    o_rtn_val = ndate3_(&i_iy, &i_im, &i_id, &i_ny, &i_nm, &i_nd);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_datec1(obj, cform, idate)
    VALUE obj, cform, idate;
{
    char *io_cform;
    integer i_idate;

    if (TYPE(cform) != T_STRING) {
      cform = rb_funcall(cform, rb_intern("to_str"), 0);
    }
    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }

    io_cform = ALLOCA_N(char, strlen(StringValuePtr(cform))+1);
    strcpy(io_cform, StringValuePtr(cform));
    i_idate = NUM2INT(idate);


    datec1_(io_cform, &i_idate, (ftnlen)strlen(io_cform));

    cform = rb_str_new2(io_cform);


    return cform;

}

static VALUE
dcl_datec2(obj, cform, iy, itd)
    VALUE obj, cform, iy, itd;
{
    char *io_cform;
    integer i_iy;
    integer i_itd;

    if (TYPE(cform) != T_STRING) {
      cform = rb_funcall(cform, rb_intern("to_str"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }

    io_cform = ALLOCA_N(char, strlen(StringValuePtr(cform))+1);
    strcpy(io_cform, StringValuePtr(cform));
    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);


    datec2_(io_cform, &i_iy, &i_itd, (ftnlen)strlen(io_cform));

    cform = rb_str_new2(io_cform);


    return cform;

}

static VALUE
dcl_datec3(obj, cform, iy, im, id)
    VALUE obj, cform, iy, im, id;
{
    char *io_cform;
    integer i_iy;
    integer i_im;
    integer i_id;

    if (TYPE(cform) != T_STRING) {
      cform = rb_funcall(cform, rb_intern("to_str"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    io_cform = ALLOCA_N(char, strlen(StringValuePtr(cform))+1);
    strcpy(io_cform, StringValuePtr(cform));
    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);


    datec3_(io_cform, &i_iy, &i_im, &i_id, (ftnlen)strlen(io_cform));

    cform = rb_str_new2(io_cform);


    return cform;

}

static VALUE
dcl_dateq1(obj)
    VALUE obj;
{
    integer o_idate;
    VALUE idate;

    dateq1_(&o_idate);

    idate = INT2NUM(o_idate);


    return idate;

}

static VALUE
dcl_ndmon(obj, iy, im)
    VALUE obj, iy, im;
{
    integer i_iy;
    integer i_im;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);


    o_rtn_val = ndmon_(&i_iy, &i_im);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_dateq2(obj)
    VALUE obj;
{
    integer o_iy;
    integer o_itd;
    VALUE iy;
    VALUE itd;

    dateq2_(&o_iy, &o_itd);

    iy = INT2NUM(o_iy);
    itd = INT2NUM(o_itd);


    return rb_ary_new3(2, iy, itd);

}

static VALUE
dcl_cmon(obj, im)
    VALUE obj, im;
{
    integer i_im;
    char *o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }

    i_im = NUM2INT(im);

    o_rtn_val= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_rtn_val, '\0', DFLT_SIZE+1);

    cmon_(o_rtn_val, (ftnlen)DFLT_SIZE, &i_im);

    rtn_val = rb_str_new2(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_cweek(obj, iw)
    VALUE obj, iw;
{
    integer i_iw;
    char *o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iw) != T_BIGNUM) || (TYPE(iw) != T_FIXNUM)) {
      iw = rb_funcall(iw, rb_intern("to_i"), 0);
    }

    i_iw = NUM2INT(iw);

    o_rtn_val= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_rtn_val, '\0', DFLT_SIZE+1);

    cweek_(o_rtn_val, (ftnlen)DFLT_SIZE, &i_iw);

    rtn_val = rb_str_new2(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_iweek1(obj, idate)
    VALUE obj, idate;
{
    integer i_idate;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(idate) != T_BIGNUM) || (TYPE(idate) != T_FIXNUM)) {
      idate = rb_funcall(idate, rb_intern("to_i"), 0);
    }

    i_idate = NUM2INT(idate);


    o_rtn_val = iweek1_(&i_idate);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_iweek2(obj, iy, itd)
    VALUE obj, iy, itd;
{
    integer i_iy;
    integer i_itd;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(itd) != T_BIGNUM) || (TYPE(itd) != T_FIXNUM)) {
      itd = rb_funcall(itd, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_itd = NUM2INT(itd);


    o_rtn_val = iweek2_(&i_iy, &i_itd);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_iweek3(obj, iy, im, id)
    VALUE obj, iy, im, id;
{
    integer i_iy;
    integer i_im;
    integer i_id;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }
    if ((TYPE(im) != T_BIGNUM) || (TYPE(im) != T_FIXNUM)) {
      im = rb_funcall(im, rb_intern("to_i"), 0);
    }
    if ((TYPE(id) != T_BIGNUM) || (TYPE(id) != T_FIXNUM)) {
      id = rb_funcall(id, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);
    i_im = NUM2INT(im);
    i_id = NUM2INT(id);


    o_rtn_val = iweek3_(&i_iy, &i_im, &i_id);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_ndyear(obj, iy)
    VALUE obj, iy;
{
    integer i_iy;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }

    i_iy = NUM2INT(iy);


    o_rtn_val = ndyear_(&i_iy);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}
void
init_misc1_datelib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "date12", dcl_date12, 1);
    rb_define_module_function(mDCL, "date13", dcl_date13, 1);
    rb_define_module_function(mDCL, "date21", dcl_date21, 2);
    rb_define_module_function(mDCL, "date23", dcl_date23, 2);
    rb_define_module_function(mDCL, "date31", dcl_date31, 3);
    rb_define_module_function(mDCL, "date32", dcl_date32, 3);
    rb_define_module_function(mDCL, "datef1", dcl_datef1, 2);
    rb_define_module_function(mDCL, "datef2", dcl_datef2, 3);
    rb_define_module_function(mDCL, "datef3", dcl_datef3, 4);
    rb_define_module_function(mDCL, "dateg1", dcl_dateg1, 2);
    rb_define_module_function(mDCL, "dateg2", dcl_dateg2, 4);
    rb_define_module_function(mDCL, "dateg3", dcl_dateg3, 6);
    rb_define_module_function(mDCL, "ndate1", dcl_ndate1, 2);
    rb_define_module_function(mDCL, "ndate2", dcl_ndate2, 4);
    rb_define_module_function(mDCL, "ndate3", dcl_ndate3, 6);
    rb_define_module_function(mDCL, "datec1", dcl_datec1, 2);
    rb_define_module_function(mDCL, "datec2", dcl_datec2, 3);
    rb_define_module_function(mDCL, "datec3", dcl_datec3, 4);
    rb_define_module_function(mDCL, "dateq1", dcl_dateq1, 0);
    rb_define_module_function(mDCL, "ndmon", dcl_ndmon, 2);
    rb_define_module_function(mDCL, "dateq2", dcl_dateq2, 0);
    rb_define_module_function(mDCL, "cmon", dcl_cmon, 1);
    rb_define_module_function(mDCL, "cweek", dcl_cweek, 1);
    rb_define_module_function(mDCL, "iweek1", dcl_iweek1, 1);
    rb_define_module_function(mDCL, "iweek2", dcl_iweek2, 2);
    rb_define_module_function(mDCL, "iweek3", dcl_iweek3, 3);
    rb_define_module_function(mDCL, "ndyear", dcl_ndyear, 1);
}
