#
# uipk02.rb
#
# $Id: uipk02.rb,v 1.1 2012/03/09 02:02:12 koshiro Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 50
ny = 50

z = NArray.sfloat(nx, ny)
p z.rank
p z.class

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    z[i,j] = - (i-(nx-1)/2.0)**2 - (j-(ny-1)/2.0)**2
  end
end

#-- graph ---
DCL::swiset('WINDOW_HEIGHT', 300)
DCL::swiset('WINDOW_WIDTH', 300)

iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::gropn iws
DCL::grfrm
DCL::grswnd(-1.0, 1.0, -1.0, 1.0)
DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
DCL::grstrn(1)
DCL::grstrf

DCL::uipdat(z)

DCL::uxaxdv('t', 0.1, 0.5)
DCL::uxaxdv('b', 0.1, 0.5)
DCL::uyaxdv('l', 0.1, 0.5)
DCL::uyaxdv('r', 0.1, 0.5)

DCL::grcls
