************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER CF*80
      PARAMETER(PI=3.1415926535897932385D0)
      PARAMETER(IU=11)      
*      PARAMETER(MM=170)
      PARAMETER(MM=21)
      PARAMETER(LM=(MM+1)*(MM+1))
      PARAMETER(NB=1024*8)
      DIMENSION AVT(LM),W(LM*3)
      EXTERNAL SBDAVT,SBDISS

      CF='test.dat'
      OMEGA=0
      ISEED=1
*      READ(5,*) CF,OMEGA,ISEED

*---- OPEN SUBROUTINE PACKAGE AND INITIALIZE VARIABLES -----------------

      LEV=3                    !ⳬǴΥץ饷γ
      ITM=10                    !ȯŸ륹ƥå׿
*      NDV=300                    !Runge-KuttaǤΥƥåʬ
      NDV=30                    !Runge-KuttaǤΥƥåʬ      
*      DT=3D0                    !եϤλֳִ
      DT=1D0                    !եϤλֳִ      

*      DNU=1000D0/(1D0*(MM*(MM+1)))**LEV
      DNU=1D0/(1D0*(MM*(MM+1)))**LEV

      CALL SBOPEN(LEV,DNU,NDV,DT,OMEGA,ISEED)
      CALL SBINIT(AVT)

*---- OPEN FHPACK ------------------------------------------------------

      CALL FHUOPN(IU,CF,'W',NB)

*---- TIME EVOLUTION BY RUNGE-KUTTA METHOD -----------------------------

      I=0
      TIM=0
      CALL FEPUTS(IU,LM,AVT)
      CALL SBCHCK(I,AVT)

      DO I=1,ITM
        call aptime(tim0)
        CALL TDRKNU(LM,NDV,DT,TIM,AVT,W,SBDISS,SBDAVT)
        call aptime(tim1)
        CALL FEPUTS(IU,LM,AVT)
        call aptime(tim2)
        CALL SBCHCK(I,AVT)
        call aptime(tim3)
        print *,tim1-tim0,tim2-tim1,tim3-tim2
      END DO

*---- CLOSE FHPACK -----------------------------------------------------

      CALL FHUCLS(IU)

      END
************************************************************************
*     OPEN SUBROUTINE PACKAGE
************************************************************************
      SUBROUTINE SBOPEN(LEV,DNU,NDV,DT,OMEGAD,ISEEDD)

      IMPLICIT REAL*8(A-H,O-Z)
*      PARAMETER(MM=170,JM=128,IM=256)
      PARAMETER(MM=21,JM=32,IM=64)
      PARAMETER(LM=(MM+1)*(MM+1))
      PARAMETER(ID=IM+1,JD=JM+1)
      PARAMETER(IW=IM+5,JW=JD)
      PARAMETER(PI=3.1415926535897932385D0)
      PARAMETER(SQRT3=1.7320508075688772935D0)
      PARAMETER(GAMMA=18,N0=7)

      DIMENSION PSI((MM+2)*(MM+2)),AVT(LM),DAVT(LM)
      DIMENSION DN(LM),DRN(LM),DIST(MM)
      DIMENSION RN(LM,2),IRM(LM,2)
      DIMENSION G(ID,JD)

      DIMENSION IT(5),T(IM*2),Y(JM/2,4)
      DIMENSION IP(((MM+1)/2+MM+1)*2),P(((MM+1)/2+MM+1)*JM)
      DIMENSION R(((MM+1)/2*2+3)*(MM/2+1))
      DIMENSION IP2(2*((MM+1)/2+MM+1)*2),P2(2*((MM+1)/2+MM+1)*JM)
      DIMENSION R2(2*((MM+1)/2*2+3)*(MM/2+1))
      DIMENSION IP3(3*((MM+1)/2+MM+1)*2),P3(3*((MM+1)/2+MM+1)*JM)
      DIMENSION R3(3*((MM+1)/2*2+3)*(MM/2+1))
      DIMENSION IA((MM+1)*(MM+1),4)
      DIMENSION A((MM+1)*(MM+1),6)
      DIMENSION Q(3*((MM+1)/2+MM+1)*JM)
      DIMENSION WW(3*JW*IW),WS(3*JW*IW)
      SAVE

      OMEGA=OMEGAD
      ISEED=ISEEDD
      print *,'OMEGA=',OMEGA,' ISEED=',ISEED

      CALL SNINIT(MM,IM,JM,IT,T,Y,IP,P,R,IA,A)
      CALL SNKINI(MM,JM,2,IP,P,R,IP2,P2,R2)
      CALL SNKINI(MM,JM,3,IP,P,R,IP3,P3,R3)
      CALL SPNINI(MM,RN)
      CALL SPMINI(MM,IRM)

      SDIST=0
      DO N=2,MM
        DIST(N)=(1D0*N)**(GAMMA/2)/(N+N0)**GAMMA
        SDIST=SDIST+DIST(N)
      END DO
      DO N=2,MM
        DIST(N)=DIST(N)/SDIST
      END DO

      DTDNU=DNU*DT/(2*NDV)

      DRN(1)=1
      DO L=1,LM
        DRN(L)=EXP(-DTDNU*ABS(RN(L,1))**LEV)        
      END DO

      RETURN
*-----------------------------------------------------------------------
*     CALCULATION OF d(AVT)/dt
*-----------------------------------------------------------------------
      ENTRY SBDAVT(TIM,AVT,DAVT)

      CALL SPCLAP(MM,AVT,PSI,RN(1,2))
      PSI(3)=PSI(3)+OMEGA/SQRT3

      CALL SPNJCB(MM,IM,ID,JM,JD,
     &  PSI,AVT,DAVT,IT,T,Y,IP2,P2,R2,IP3,P3,R3,IA,A,Q,WS,WW)

      DO L=1,LM
        DAVT(L)=-DAVT(L)
      END DO

      RETURN
*-----------------------------------------------------------------------
*     CALCULATION OF THE EFFECT OF VISCOSITY
*-----------------------------------------------------------------------
      ENTRY SBDISS(TIM,DTIM,AVT)

      DO L=1,LM
        AVT(L)=DRN(L)*AVT(L)
      END DO

      RETURN
*-----------------------------------------------------------------------
*     CHECK ENERGY AND ENSTROPHY CONSERVATION
*-----------------------------------------------------------------------
      ENTRY SBCHCK(I,AVT)

      CALL SPCLAP(MM,AVT,PSI,RN(1,2))
      PSI(3)=PSI(3)+OMEGA/SQRT3

      ENE=0
      ENS=0
      DO L=2,LM
        ENE=ENE-RN(L,1)*PSI(L)*PSI(L)
        ENS=ENS+RN(L,1)*RN(L,1)*PSI(L)*PSI(L)
      END DO
      ENE=ENE/2
      ENS=ENS/2

      WRITE(6,'(I5,2F15.10)') I,ENE,ENS

      RETURN
*-----------------------------------------------------------------------
*     INITIALIZATION OF VAR
*-----------------------------------------------------------------------
      ENTRY SBINIT(AVT)

      CALL BSSET0(LM,AVT)

*/ бپ(ץͥ꡼٤Τ) /*
      AVT(3)=2*OMEGA/SQRT3

*/ پΥڥȥνͤ /*

*      ISEED=1
      DO N=2,MM
        ENE=0
        DO M=-N,N
          CALL SNNM2L(N,M,L)
          CALL ISNORM(ISEED,AVT(L))
          ENE=ENE+0.5D0/(N*(N+1))*AVT(L)*AVT(L)
        END DO
        DO M=-N,N
          CALL SNNM2L(N,M,L)
          AVT(L)=AVT(L)/SQRT(ENE/DIST(N))
        END DO
      END DO
      
      END
********************************************************************
      SUBROUTINE ISNORM(ISEED,R)

      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(PI=3.1415926535897932385D0)
      DATA IFLAG/0/
      SAVE

      IF(IFLAG.EQ.0) THEN
        CALL ISRAND(ISEED,X1)
        CALL ISRAND(ISEED,X2)
        Y1=SQRT(-2*LOG(X1))*COS(2*PI*X2)
        Y2=SQRT(-2*LOG(X1))*SIN(2*PI*X2)
        R=Y1
        IFLAG=1
      ELSE
        R=Y2
        IFLAG=0
      END IF

      END
********************************************************************
      SUBROUTINE ISRAND(ISEED,R)

      IMPLICIT REAL*8(A-H,O-Z)
      PARAMETER(IA=1664525,IC=1013904223,AM=2D0**32)

      ISEED=IA*ISEED+IC
      R=(IBCLR(ISEED,31)+0.5D0)/AM

      IF(BTEST(ISEED,31)) THEN
        R=R+0.5D0
      END IF

      END
