!*************************************************************************
!*   ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING          *
!*   Copyright (C) 2000 Keiichi Ishioka                                  *
!*                                                                       *
!*   This library is free software; you can redistribute it and/or       *
!*   modify it under the terms of the GNU Library General Public         *
!*   License as published by the Free Software Foundation; either        *
!*   version 2 of the License, or (at your option) any later version.    *
!*                                                                       *
!*   This library is distributed in the hope that it will be useful,     *
!*   but WITHOUT ANY WARRANTY; without even the implied warranty of      *
!*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   *
!*   Library General Public License for more details.                    *
!*                                                                       *
!*   You should have received a copy of the GNU Library General Public   *
!*   License along with this library; if not, write to the Free          *
!*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  *
!*************************************************************************
!************************************************************************
!*     CALCULATE JACOBIAN                                      2000/10/02
!*               for sin and cos series                        2001/02/13
!************************************************************************
!
!ɽ: c2ajcc.f90/ 䥳ӥη׻
!
!: 2011/02/18 ʿ Fortran90 

subroutine c2ajcc(lm,km,jm,im,sa,sb,sc,ws,wg,itj,tj,iti,ti)
  implicit none
  integer, intent(in) :: lm
  integer, intent(in) :: km
  integer, intent(in) :: jm
  integer, intent(in) :: im
  real(8), intent(in) :: sa(-km:km,lm)
  real(8), intent(in) :: sb(-km:km,0:lm)
  real(8), intent(inout) :: sc(-km:km,0:lm)
  real(8) :: ws(-km:km,0:lm)
  real(8) :: wg((jm+1)*im,3)
  integer :: itj(5)
  integer :: tj(jm*6)
  integer :: iti(5)
  integer :: ti(im*2)
  integer :: ji
  integer :: k
  integer :: l

!! a --> wg(ji,3)
  call c2s2ga(lm,km,jm,im,sa,wg(1,3),wg,itj,tj,iti,ti,3)

!! b/y --> wg(ji,2)
  call bsset0(2*km+1,ws)
  do l=1,lm
    do k=-km,km
      ws(k,l)=-l*sb(k,l)
    end do
  end do
  call c2s2ga(lm,km,jm,im,ws(-km,1),wg(1,2),wg,itj,tj,iti,ti,3)

!! a  b/y  --> wg(ji,2)
  do ji=1,(jm+1)*im
    wg(ji,2)=wg(ji,3)*wg(ji,2)
  end do
!! a  b/y Υڥȥ --> ws
  call c2g2sa(lm,km,jm,im,wg(1,2),ws,wg,itj,tj,iti,ti,4)

!! (a  b/y)/x --> sc
  do l=0,lm
    do k=-km,km
      sc(k,l)=-k*ws(-k,l)
    end do
  end do
!! b/x --> wg(ji,2)
  do l=0,lm
    do k=-km,km
      ws(k,l)=-k*sb(-k,l)
    end do
  end do
  call c2s2ga(lm,km,jm,im,ws,wg(1,2),wg,itj,tj,iti,ti,4)

!! a  b/x  --> wg(ji,2)
  do ji=1,(jm+1)*im
    wg(ji,2)=wg(ji,3)*wg(ji,2)
  end do

!! a  b/x Υڥȥ --> ws
  call c2g2sa(lm,km,jm,im,wg(1,2),ws(-km,1),wg,itj,tj,iti,ti,3)

! finally calculate jacobian
  do l=1,lm
    do k=-km,km
      sc(k,l)=sc(k,l)-l*ws(k,l)
    end do
  end do

end subroutine c2ajcc


