!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module ƥȥץ (ַ׻)
!
!  2011/12/10  ݹ
!
program eea_test_interpolate

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32              ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: yxa_Data1(0:jm-1,0:im-1,2)   ! ʻҥǡ
  real(8)            :: eea_Data(-lm:lm,-km:km,2)    ! ڥȥǡ

  real(8)            :: xa_Data(2)                   ! ʻҥǡ
  real(8)            :: ya_Data(2)                   ! ʻҥǡ
  real(8)            :: a_Data(2)                    ! ʻҥǡ

  integer            :: k=2,l=5
  integer            :: i, j

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = 0.0d0, xmax=4.0d0
  real(8), parameter :: ymin = 2.0d0, ymax=4.0d0

  real(8), parameter :: x0 = 2.0/3.0, x1=3.0/5.0d0
  real(8), parameter :: y0 = 1.0/7.0, y1=5.0/9.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','eea_test_interpolate', &
       'eea_module transform function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  xa_Data(1) = x0 ; xa_Data(2) = x1
  ya_Data(1) = y0 ; ya_Data(2) = y1

  yxa_Data(:,:,1) = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  eea_Data = eea_yxa(yxa_Data)

  a_Data(1) = sin(k*pi*xa_Data(1))*sin(l*pi*ya_Data(1))
  a_Data(2) = cos(k*pi*xa_Data(2))*cos(l*pi*ya_Data(2))

  call check1d(a_Data, &
       a_Interpolate_eea(eea_Data, xa_Data, ya_Data), &
       'Interpolation sin(k*pi*X)*sin(l*pi*Y),cos(k*pi*X)*cos(l*pi*Y)')

  yxa_Data(:,:,1) = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  eea_Data = eea_yxa(yxa_Data)

  a_Data(1) = sin(k*pi*xa_Data(1))*cos(l*pi*ya_Data(1))
  a_Data(2) = cos(k*pi*xa_Data(2))*sin(l*pi*ya_Data(2))

  call check1d(a_Data, &
       a_Interpolate_eea(eea_Data, xa_Data, ya_Data), &
       'Interpolation sin(k*pi*X)*cos(l*pi*Y),cos(k*pi*X)*sin(l*pi*Y)')

  yxa_Data(:,:,1) = sin(k*pi*yx_X)
  yxa_Data(:,:,2) = cos(k*pi*yx_X)
  eea_Data = eea_yxa(yxa_Data)

  a_Data(1) = sin(k*pi*xa_Data(1))
  a_Data(2) = cos(k*pi*xa_Data(2))

  call check1d(a_Data, &
       a_Interpolate_eea(eea_Data, xa_Data, ya_Data), &
       'Interpolation sin(k*pi*X),cos(k*pi*X)')

  yxa_Data(:,:,1) = cos(l*pi*yx_Y)
  yxa_Data(:,:,2) = sin(l*pi*yx_Y)
  eea_Data = eea_yxa(yxa_Data)

  a_Data(1) = cos(l*pi*ya_Data(1))
  a_Data(2) = sin(l*pi*ya_Data(2))

  call check1d(a_Data, &
       a_Interpolate_eea(eea_Data, xa_Data, ya_Data), &
       'Interpolation cos(l*pi*Y),sin(l*pi*Y)')

  call MessageNotify('M','eea_test_Interpolate', &
       'eea_module Interpolation function tests succeeded!')

 stop
contains

  subroutine check1d(var1,sol1,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var1(:)                   ! Ƚꤹ
    real(8) :: sol1(:)                   ! 
    character(len=*)  :: funcname
    call AssertEqual(      &
      message = funcname,  &
      answer = sol1,       &
      check = var1,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check1d

end program eea_test_interpolate

